/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.legacy.apache;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.objectweb.jasmine.jade.util.ExecutableCmd;
import org.objectweb.jasmine.jade.util.FileCmd;
import org.objectweb.jasmine.jade.util.JadeException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator,
ManagedService {
    private static final String PID = "org.ow2.jasmine.jade.wrapper.apache";
    private Dictionary properties = null;
    private ServiceRegistration registration = null;
    private BundleContext context = null;
    private LogService logger = null;
    private String dirLocal = null;
    private String dirInstall = null;
    private static final String APACHE_DIR = "apache2" + File.separator;
    private static final String APACHE_ARCHIVE = "apache-2.2.2.tgz";
    private boolean started = false;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public void start(BundleContext context) throws Exception {
        if (!this.started) {
            this.registration = context.registerService((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = Activator.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), (Object)this, this.getDefaults());
            this.context = context;
            ServiceReference sr = context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Activator.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
            this.logger = (LogService)context.getService(sr);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.removeApache();
        this.started = false;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties != null) {
            this.properties = properties;
            try {
                if (!this.started) {
                    this.dirLocal = this.getDirLocal();
                    this.dirInstall = this.dirLocal + APACHE_DIR;
                    this.started = this.install();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getDirLocal() {
        String result = (String)this.properties.get("local.dir");
        if (!result.endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    private Dictionary getDefaults() {
        Hashtable<String, String> defaults = new Hashtable<String, String>();
        ((Dictionary)defaults).put("service.pid", PID);
        return defaults;
    }

    private boolean install() {
        this.logger.log(3, "The apache directory is localised on : " + this.dirLocal);
        try {
            File apacheArchive;
            File dir = new File(this.dirLocal);
            if (!dir.exists()) {
                ExecutableCmd.syncExec((String)("mkdir " + this.dirLocal), null);
            }
            if (!(apacheArchive = new File(this.dirLocal + APACHE_ARCHIVE)).exists()) {
                this.logger.log(3, "copying the 'apache-2.2.2.tgz' file to the local dir...");
                URL url = this.context.getBundle().getResource(APACHE_ARCHIVE);
                this.logger.log(3, this.context.getBundle().getLocation());
                this.logger.log(3, url.getFile());
                BufferedInputStream fis = new BufferedInputStream(url.openConnection().getInputStream());
                FileOutputStream out = new FileOutputStream(apacheArchive);
                this.logger.log(3, "available : " + fis.available());
                while (fis.available() > 0) {
                    byte[] byts = new byte[fis.available()];
                    fis.read(byts);
                    out.write(byts);
                }
                out.flush();
                fis.close();
                out.close();
                this.logger.log(3, "done");
            }
            Runtime r = Runtime.getRuntime();
            this.logger.log(3, "extracting the 'apache-2.2.2.tgz' in the local dir...");
            this.logger.log(3, "tar xf " + this.dirLocal + APACHE_ARCHIVE + " --directory=" + this.dirLocal);
            Process p = r.exec("tar xf " + this.dirLocal + APACHE_ARCHIVE + " --directory=" + this.dirLocal);
            p.waitFor();
            this.logger.log(3, "done");
            apacheArchive.delete();
            return true;
        }
        catch (IOException e) {
            this.logger.log(1, "failed", (Throwable)e);
            return false;
        }
        catch (JadeException e) {
            this.logger.log(1, "failed", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            this.logger.log(1, "failed", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeApache() {
        String filename = this.dirInstall + "logs" + File.separator + "httpd.pid";
        this.logger.log(3, "stopping the Apache HTTP server...");
        try {
            FileCmd.assertFileExists((String)filename);
            String s = null;
            try {
                BufferedReader br = new BufferedReader(new FileReader(filename));
                s = br.readLine();
            }
            catch (IOException e) {
                this.logger.log(1, "Error during read of the Apache pid file", (Throwable)e);
            }
            try {
                ExecutableCmd.syncExec((String)(this.dirInstall + "bin" + File.separator + "apachectl stop"), null);
                ExecutableCmd.asyncExec((String)("kill -TERM " + s), null);
                this.logger.log(3, "done");
            }
            catch (Exception e) {
                this.logger.log(1, "Error while stopping the Apache HTTP server", (Throwable)e);
            }
        }
        catch (JadeException e) {
            this.logger.log(1, "Error while stopping the Apache HTTP server", (Throwable)e);
        }
        finally {
            this.logger.log(3, "deleting apache directory...");
            try {
                ExecutableCmd.syncExec((String)("rm -r " + this.dirInstall), null);
                this.logger.log(3, "done");
            }
            catch (JadeException e) {
                this.logger.log(1, "Error while erasing the Apache HTTP server directory", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

