/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.configurator;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.objectweb.jasmine.configurator.ConfigurationException;
import org.objectweb.jasmine.configurator.Configurator;
import org.objectweb.jasmine.configurator.ConfiguratorComposite;
import org.objectweb.jasmine.util.JasmineWrapperUtil;

public abstract class AbstractConfiguratorComposite
implements ConfiguratorComposite {
    protected Map<String, Configurator> configurators = new HashMap<String, Configurator>();

    public void addConfigurator(String prefix, Configurator configurator) {
        this.configurators.put(prefix, configurator);
    }

    public void removeConfigurator(Configurator configurator) {
        this.configurators.remove(configurator);
    }

    public void configure() throws ConfigurationException {
        Set<String> prefixes = this.configurators.keySet();
        for (String prefix : prefixes) {
            this.configurators.get(prefix).configure();
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        Set<String> prefixes = this.configurators.keySet();
        for (String prefix : prefixes) {
            JasmineWrapperUtil.concatProperties(properties, this.configurators.get(prefix).getProperties());
        }
        return properties;
    }

    public Object getProperty(String key) {
        String prefix;
        StringTokenizer tokenizer = new StringTokenizer(key, "-");
        if (tokenizer.hasMoreTokens() && this.configurators.containsKey(prefix = tokenizer.nextToken())) {
            return this.configurators.get(prefix).getProperty(key);
        }
        return null;
    }

    public boolean setProperty(String key, Object value) {
        String prefix;
        StringTokenizer tokenizer;
        Object val = null;
        val = value;
        if (value instanceof String) {
            String sValue = (String)value;
            if (sValue.matches("true") || sValue.matches("false")) {
                val = Boolean.parseBoolean(sValue);
            }
            if (sValue.matches("\\d+")) {
                val = Integer.parseInt(sValue);
            }
        }
        if ((tokenizer = new StringTokenizer(key, "-")).hasMoreTokens() && this.configurators.containsKey(prefix = tokenizer.nextToken())) {
            this.configurators.get(prefix).setProperty(key, val);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Object o : this.getProperties().keySet()) {
            buffer.append(this.getProperties().get(o));
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

