/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.configurator.statik.velocity;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.objectweb.jasmine.configurator.ConfigurationException;
import org.objectweb.jasmine.configurator.statik.velocity.VelocityConfigurator;

public abstract class AbstractVelocityConfigurator
implements VelocityConfigurator {
    protected VelocityEngine ve = null;
    protected VelocityContext context = null;
    protected Template template = null;

    public AbstractVelocityConfigurator() {
        this.ve = new VelocityEngine();
        this.context = new VelocityContext();
        this.context.put("this", (Object)this);
    }

    public AbstractVelocityConfigurator(ClassLoader cl) {
        try {
            this.ve = new VelocityEngine();
            this.context = new VelocityContext();
            this.context.put("this", (Object)this);
            this.ve.setProperty("resource.loader", (Object)"class");
            this.ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            if (cl != null) {
                this.ve.setProperty("class.resource.loader.classloader", (Object)cl);
            }
            this.ve.init();
        }
        catch (ResourceNotFoundException rnfe) {
            System.out.println("cannot find template " + this.getTemplateFile());
        }
        catch (ParseErrorException pee) {
            System.out.println("Syntax error in template " + this.getTemplateFile() + ":" + (Object)((Object)pee));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AbstractVelocityConfigurator(VelocityContext vcontext, ClassLoader cl) {
        try {
            this.ve = new VelocityEngine();
            this.context = new VelocityContext((Context)vcontext);
            this.context.put("this", (Object)this);
            this.ve.setProperty("resource.loader", (Object)"class");
            this.ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            if (cl != null) {
                this.ve.setProperty("class.resource.loader.classloader", (Object)cl);
            }
            this.ve.init();
        }
        catch (ResourceNotFoundException rnfe) {
            System.out.println("cannot find template " + this.getTemplateFile());
        }
        catch (ParseErrorException pee) {
            System.out.println("Syntax error in template " + this.getTemplateFile() + ":" + (Object)((Object)pee));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void configure() throws ConfigurationException {
        try {
            this.write(this.getGeneratedFileName());
        }
        catch (ResourceNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (ParseErrorException e) {
            throw new ConfigurationException(e);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public boolean setProperty(String key, Object value) {
        this.context.put(key, value);
        return true;
    }

    public Object getProperty(String key) {
        return this.context.get(key);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (Object key : this.context.getKeys()) {
            properties.put(key, this.context.get(key.toString()));
        }
        return properties;
    }

    public VelocityContext getContext() {
        return this.context;
    }

    private void write(String filename) throws ResourceNotFoundException, ParseErrorException, Exception {
        File file = new File(filename);
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        out.write(this.generate());
        out.close();
    }

    private String generate() throws ResourceNotFoundException, ParseErrorException, Exception {
        this.template = this.ve.getTemplate(this.getTemplateFile());
        StringWriter writer = new StringWriter();
        if (this.template != null) {
            this.template.merge((Context)this.context, (Writer)writer);
        }
        return new String(writer.getBuffer());
    }
}

