/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.configurator.statik.velocity.templategenerator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.objectweb.jasmine.configurator.statik.velocity.templategenerator.TemplateGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplateGenerator
implements TemplateGenerator {
    protected String prefix;
    protected Set<String> templateVars = new HashSet<String>();

    public AbstractTemplateGenerator(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Set<String> getProperties() {
        return this.templateVars;
    }

    protected List<String[]> proceedProperty(String key, String value) {
        ArrayList<String[]> res = new ArrayList<String[]>();
        String prfx = this.format(key);
        if (value.contains("://")) {
            StringTokenizer tokenizer = new StringTokenizer(value, "://");
            String protocol = tokenizer.nextToken();
            res.add(new String[]{prfx + "-protocol", protocol});
            if (tokenizer.hasMoreTokens()) {
                String address = tokenizer.nextToken();
                res.add(new String[]{prfx + "-host", address});
                if (tokenizer.hasMoreTokens()) {
                    String port = tokenizer.nextToken();
                    res.add(new String[]{prfx + "-port", port});
                }
            }
        } else {
            res.add(new String[]{prfx, value});
        }
        return res;
    }

    protected String format(String key) {
        return this.prefix + "-" + key.replace(".", "-");
    }

    protected String getDefaultPattern(String var, String value) {
        return "#if( !$ ) #set($ = \"\") #end".replace("$", "$" + var).replace("\"\"", "\"" + value + "\"");
    }
}

