/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.configurator.statik.velocity.templategenerator;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.objectweb.jasmine.configurator.statik.velocity.templategenerator.PropertiesTemplateGenerator;
import org.objectweb.jasmine.configurator.statik.velocity.templategenerator.XMLTemplateGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorLauncher {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage : java GeneratorLauncher directory_containing_conf ");
        } else {
            String dirName = args[0];
            File dir = new File(dirName);
            if (!dir.isDirectory()) {
                System.err.println(dirName + " is not a directory.");
                System.out.println("Usage : java GeneratorLauncher directory_containing_conf ");
            } else {
                FileFilter xmlFileFilter = new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".xml");
                    }
                };
                FileFilter propertiesFileFilter = new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getName().endsWith(".properties");
                    }
                };
                File[] xmlFile = dir.listFiles(xmlFileFilter);
                File[] propertiesFile = dir.listFiles(propertiesFileFilter);
                StringBuffer buffer = new StringBuffer();
                XMLTemplateGenerator xtg = null;
                File f = null;
                String prefix = null;
                for (int i = 0; i < xmlFile.length; ++i) {
                    f = xmlFile[i];
                    prefix = f.getName().replace(".xml", "").replace("-", "_").toLowerCase();
                    xtg = new XMLTemplateGenerator(prefix);
                    try {
                        System.out.println("Generating " + f.getName() + " ...");
                        xtg.generate(f);
                        buffer.append(GeneratorLauncher.setToString(xtg.getProperties()));
                        buffer.append("\n");
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                PropertiesTemplateGenerator ptg = null;
                for (int i = 0; i < propertiesFile.length; ++i) {
                    f = propertiesFile[i];
                    prefix = f.getName().replace(".properties", "").replace("-", "_").toLowerCase();
                    ptg = new PropertiesTemplateGenerator(prefix);
                    try {
                        System.out.println("Generating " + f.getName() + " ...");
                        ptg.generate(f);
                        buffer.append(GeneratorLauncher.setToString(ptg.getProperties()));
                        buffer.append("\n");
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("\nGenerated properties : ");
                System.out.println(buffer.toString());
            }
        }
    }

    private static String setToString(Set<String> set) {
        StringBuffer buffer = new StringBuffer();
        for (String s : set) {
            buffer.append(s);
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

