/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jade.wrapper.apache.configurator;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.velocity.VelocityContext;
import org.objectweb.jasmine.configurator.ConfigurationException;
import org.objectweb.jasmine.configurator.statik.velocity.VelocityConfiguratorImpl;

public class WorkersConfigurator
extends VelocityConfiguratorImpl {
    public WorkersConfigurator(VelocityContext vcontext, ClassLoader cl, String templateName, String fileName) {
        super(vcontext, cl, templateName, fileName);
    }

    public void configure() throws ConfigurationException {
        super.configure();
        this.setProperty("workers-list", new HashSet());
    }

    public boolean setProperty(String key, Object value) {
        if (key.equals("workers")) {
            this.setWorker(key, value.toString());
            return true;
        }
        return super.setProperty(key, value);
    }

    public void setWorker(String key, String worker) {
        Set workersSet = null;
        StringTokenizer tokenizer = new StringTokenizer(worker, ",");
        Object o = this.getProperty("workers-list");
        workersSet = o == null ? new HashSet() : (o instanceof Set ? (Set)o : new HashSet());
        if (tokenizer.countTokens() > 2) {
            String workerName = tokenizer.nextToken();
            String workerHost = tokenizer.nextToken();
            String workerPort = tokenizer.nextToken();
            workersSet.add(workerName);
            this.setProperty("worker-" + workerName + "-host", workerHost);
            this.setProperty("worker-" + workerName + "-port", workerPort);
            this.setProperty("workers-list", workersSet);
        }
    }
}

