/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.jasmine.monitoring.mbeancmd.graph.SerieListener;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.SerieConfig;

public class Serie
implements Runnable {
    private SerieConfig conf = null;
    private PipedOutputStream source = null;
    private LineNumberReader in = null;
    private List listeners = new LinkedList();
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public Serie(SerieConfig conf) throws IOException {
        this.conf = conf;
        this.source = new PipedOutputStream();
        this.in = new LineNumberReader(new InputStreamReader(new PipedInputStream(this.source)));
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("New serie: " + conf.getId());
        }
    }

    public PipedOutputStream getSource() {
        return this.source;
    }

    public SerieConfig getConfig() {
        return this.conf;
    }

    public void addSerieListener(SerieListener listener) {
        this.listeners.add(listener);
    }

    public void run() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Serie: " + this.conf.getTitle() + " Starting...");
        }
        String sep = this.conf.getParent().getSeparator();
        boolean goOn = true;
        boolean isHeader = true;
        while (goOn) {
            try {
                String ln = this.in.readLine();
                if (ln == null) {
                    goOn = false;
                    continue;
                }
                if (isHeader) {
                    isHeader = false;
                    continue;
                }
                String[] s = ln.split(sep);
                if (s.length != 2 && this.logger.isLoggable(Level.SEVERE)) {
                    this.logger.severe("Format error on series '" + this.getConfig().getId() + "' : 2 values where expected, but read [" + ln + "]");
                }
                for (SerieListener sl : this.listeners) {
                    if (this.conf.getXType() == 3 && this.conf.getYType() == 2) {
                        sl.update(this.getConfig().getId(), this.parseTime(s[0]), Double.parseDouble(s[1]));
                        continue;
                    }
                    if (this.conf.getXType() == 3 && this.conf.getYType() == 1) {
                        sl.update(this.getConfig().getId(), this.parseTime(s[0]), Long.parseLong(s[1]));
                        continue;
                    }
                    if (this.conf.getXType() == 1 && this.conf.getYType() == 2) {
                        sl.update(this.getConfig().getId(), Long.parseLong(s[0]), Double.parseDouble(s[1]));
                        continue;
                    }
                    if (this.conf.getXType() == 1 && this.conf.getYType() == 1) {
                        sl.update(this.getConfig().getId(), Long.parseLong(s[0]), Long.parseLong(s[1]));
                        continue;
                    }
                    throw new IOException("Unsupported axis type : " + this.conf.getXType() + ", " + this.conf.getYType());
                }
            }
            catch (Exception e) {
                this.logger.log(Level.INFO, "Exception in serie: " + this.conf.getTitle(), e);
                goOn = false;
            }
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Serie: " + this.conf.getTitle() + " complete.");
        }
    }

    private long parseTime(String time) throws ParseException {
        SimpleDateFormat fmt = this.conf.getParent().getDateFormat();
        if (fmt == null) {
            return Long.parseLong(time);
        }
        return fmt.parse(time).getTime();
    }
}

