/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.CpuSunData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;

public class CpuSunSampler
extends Sampler {
    public CpuSunSampler(JmxContext context) {
        super(context);
    }

    public String getDefaultOn() {
        return "java.lang:type=OperatingSystem";
    }

    protected SampleData newSampleData() {
        return new CpuSunData();
    }

    protected SampleData poll(SampleData data) {
        this.pollCpuSun((CpuSunData)data);
        return data;
    }

    private void pollCpuSun(CpuSunData data) {
        long cpuTime = 0L;
        long availableProcessors = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = this.getMBeanServerConnection();
        String[] attIds = new String[]{"ProcessCpuTime", "AvailableProcessors"};
        ObjectName[] oNames = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
        for (int i = 0; i < oNames.length; ++i) {
            try {
                al = cnx.getAttributes(oNames[i], attIds);
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                cpuTime += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                availableProcessors += Long.parseLong(att.getValue().toString());
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        this.releaseMbeanServerConnection();
        data.setProcessCpuTime(cpuTime);
        data.setAvailableProcessors(availableProcessors);
        data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
        if (oNames.length > 0) {
            data.setObjectName(oNames[0]);
        }
    }
}

