/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import javax.management.Attribute;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

public class JoramQData
extends SampleData {
    private static final String header = "AdminName;Type;PendingMessages;NbMaxMsg;receiveRate;deliveryRate;PendingRequests;Threshold;creationDate;nbMsgsReceiveSinceCreation;nbMsgsDeliverSinceCreation;nbMsgsSendToDMQSinceCreation";

    public void compute(SampleData needs_cast) {
        JoramQData prev = (JoramQData)needs_cast;
        if (prev != null) {
            long deltaReceived = this.getAttributeAsLong("nbMsgsReceiveSinceCreation") - prev.getAttributeAsLong("nbMsgsReceiveSinceCreation");
            double dt = (double)(this.getSampleTime() - prev.getSampleTime()) / 1000.0;
            this.setAttribute(new Attribute("receiveRate", new Double((double)deltaReceived / dt)));
            long deltaDelivery = this.getAttributeAsLong("nbMsgsDeliverSinceCreation") - prev.getAttributeAsLong("nbMsgsDeliverSinceCreation");
            this.setAttribute(new Attribute("deliveryRate", new Double((double)deltaDelivery / dt)));
        } else {
            this.setAttribute(new Attribute("receiveRate", new Double(0.0)));
            this.setAttribute(new Attribute("deliveryRate", new Double(0.0)));
        }
    }

    protected String getInnerPrintHeader() {
        return header.replaceAll(";", JoramQData.getSeparator());
    }

    protected String getInnerPrintData() {
        return this.getAttribute("AdminName") + JoramQData.getSeparator() + this.getAttribute("Type") + JoramQData.getSeparator() + this.getAttributeAsInt("PendingMessages") + JoramQData.getSeparator() + this.getAttributeAsInt("NbMaxMsg") + JoramQData.getSeparator() + decimalFormat.format(this.getAttributeAsDouble("receiveRate")) + JoramQData.getSeparator() + decimalFormat.format(this.getAttributeAsDouble("deliveryRate")) + JoramQData.getSeparator() + this.getAttributeAsInt("PendingRequests") + JoramQData.getSeparator() + this.getAttributeAsInt("Threshold") + JoramQData.getSeparator() + this.getAttributeAsLong("creationDate") + JoramQData.getSeparator() + this.getAttributeAsLong("nbMsgsReceiveSinceCreation") + JoramQData.getSeparator() + this.getAttributeAsLong("nbMsgsDeliverSinceCreation") + JoramQData.getSeparator() + this.getAttributeAsLong("nbMsgsSendToDMQSinceCreation") + JoramQData.getSeparator();
    }
}

