/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.JoramQData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;

public class JoramQSampler
extends Sampler {
    private static final String[] attIds = new String[]{"AdminName", "Type", "PendingMessages", "NbMaxMsg", "PendingRequests", "Statistic", "Threshold"};

    public JoramQSampler(JmxContext context) {
        super(context);
    }

    public String getDefaultOn() {
        return "joramClient:type=queue,*";
    }

    protected SampleData newSampleData() {
        return new XSampleData();
    }

    protected SampleData poll(SampleData data) {
        this.pollJoramQueues((XSampleData)data);
        data.setValid(true);
        return data;
    }

    private void pollJoramQueues(XSampleData data) {
        ObjectName[] oNames = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
        for (int i = 0; i < oNames.length; ++i) {
            JoramQData qdata = new JoramQData();
            qdata.setObjectName(oNames[i]);
            qdata.setSampleTime(System.currentTimeMillis());
            this.pollJoramQueue(oNames[i], qdata);
            if (!qdata.isValid()) continue;
            data.put(oNames[i], qdata);
        }
    }

    private void pollJoramQueue(ObjectName on, JoramQData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        try {
            cnx = this.getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            this.releaseMbeanServerConnection();
            cnx = null;
            for (Attribute att : al) {
                if ("Statistic".equals(att.getName())) {
                    Hashtable ht = (Hashtable)att.getValue();
                    Attribute a1 = new Attribute("creationDate", ht.get("creationDate"));
                    data.setAttribute(a1);
                    a1 = new Attribute("nbMsgsReceiveSinceCreation", ht.get("nbMsgsReceiveSinceCreation"));
                    data.setAttribute(a1);
                    a1 = new Attribute("nbMsgsSendToDMQSinceCreation", ht.get("nbMsgsSendToDMQSinceCreation"));
                    data.setAttribute(a1);
                    a1 = new Attribute("nbMsgsDeliverSinceCreation", ht.get("nbMsgsDeliverSinceCreation"));
                    data.setAttribute(a1);
                    continue;
                }
                data.setAttribute(att);
            }
            data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
            data.setValid(true);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (ReflectionException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

