/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.JmxContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.TxData;

public class TxSampler
extends Sampler {
    public TxSampler(JmxContext context) {
        super(context);
    }

    public String getDefaultOn() {
        return "*:j2eeType=JTAResource,*";
    }

    protected SampleData newSampleData() {
        return new TxData();
    }

    protected SampleData poll(SampleData data) {
        this.pollJTM((TxData)data);
        return data;
    }

    private void pollJTM(TxData data) {
        long txCount = 0L;
        long currentTxGauge = 0L;
        long rolledbackTx = 0L;
        long timedOutTx = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"totalCurrentTransactions", "totalCommittedTransactions", "totalRolledbackTransactions", "totalExpiredTransactions"};
        ObjectName[] oNames = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
        for (int i = 0; i < oNames.length; ++i) {
            try {
                cnx = this.getMBeanServerConnection();
                al = cnx.getAttributes(oNames[i], attIds);
                this.releaseMbeanServerConnection();
                cnx = null;
                Iterator it = al.iterator();
                Attribute att = (Attribute)it.next();
                currentTxGauge += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                txCount += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                rolledbackTx += Long.parseLong(att.getValue().toString());
                att = (Attribute)it.next();
                timedOutTx += Long.parseLong(att.getValue().toString());
                data.setValid(true);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                e.getCause().printStackTrace(System.err);
            }
        }
        data.setCommittedTxCnt(txCount);
        data.setRolledbackTxCnt(rolledbackTx);
        data.setPendingTxGauge(currentTxGauge);
        data.setTimedOutTxCnt(timedOutTx);
        data.setServerInfo(this.getName(), this.getServer(), this.getDomain());
        if (oNames.length > 0) {
            data.setObjectName(oNames[0]);
        }
    }
}

