#!/bin/bash
# -  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# - JASMINe
# - Copyright (C) 2008 Bull S.A.S.
# - Contact: jasmine@ow2.org
# -
#  - This library is free software; you can redistribute it and/or
# - modify it under the terms of the GNU Lesser General Public
#  - License as published by the Free Software Foundation; either
#  - version 2.1 of the License, or any later version.
#  -
#  - This library is distributed in the hope that it will be useful,
#  - but WITHOUT ANY WARRANTY; without even the implied warranty of
#  - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  - Lesser General Public License for more details.
#  -
#  - You should have received a copy of the GNU Lesser General Public
#  - License along with this library; if not, write to the Free Software
#  - Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#  - USA
#  -
#  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#  - $Id: generate-ra.sh 1610 2008-07-03 07:44:58Z jlegrand $
#  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#

echo "#############################################################################################"
echo "#"
echo "#"
echo "#                              JMXConnection RA Building tool"
echo "#"
echo "#"

DEPLOYDIR=""
DEPLOY="false"
RACONFIG=""
JNDINAME=""
FILEPROPERTY="jmxconnectionra.properties"
INPUTFILE=""
OUTPUTFILE="JMXGeneratedRA.rar"
LEGACY="false"

black='\E[30;47m'
red='\E[31;47m'
green='\E[32;47m'
yellow='\E[33;47m'
blue='\E[34;47m'
magenta='\E[35;47m'
cyan='\E[36;47m'

#alias Reset="tput sgr0"      #  Reset text attributes to normal
                             #+ without clearing screen.

cecho ()                     # Color-echo.
                             # Argument $1 = message
                             # Argument $2 = color
{
local default_msg="No message passed."
                             # Doesn't really need to be a local variable.

message=${1:-$default_msg}   # Defaults to default message.
color=${2:-$black}           # Defaults to black, if not specified.

  echo -e "$color$message"
  tput init                      # Reset to normal.

  return
}

help(){
  echo "#   This script helps to generate new RA from the JMXConnectionRA. It uses RAConfig."
  echo "#"
  echo "#   Options :"
  echo "#"
  cecho "#		-h Print this help message" $blue
  cecho "#		-l This option has to be set if running on JOnAS 4.8.6, 4.9.2, 5.0.3 or older versions."
  cecho "#		-j <JNDIName> Set the jndiname (required)" $blue
  cecho "#		    example :" $blue
  cecho "#            		you want to deploy a jmx connection pool for the following url" $blue
  cecho "#" $blue
  cecho "#				service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas" $blue
  cecho "#" $blue
  cecho "#            		the jndi name of the RA will have to be" $blue
  cecho "#" $blue
  cecho "#                		service_jmx_rmi____jndi_rmi___localhost_1099_jrmpconnector_jonas" $blue
  cecho "#" $blue
  cecho "#		-p <file.properties> Specify a property file to build the RA. Default value " $blue
  cecho "#					is conf/jmxconnectionra.properties. This file is used" $blue
  cecho "#					to configure the RA pool." $blue
  cecho "#		-o <outputFileName> Specify the output file name of the ra. default value is " $blue
  cecho "#					JMXGeneratedRA. The .rar extension is automatically set." $blue
  cecho "#		-d If this option is set, the generated RA will be moved into the JONAS_BASE " $blue
  cecho "#					deploy directory." $blue
  echo "#"
  echo "#############################################################################################"
}

#Parse command line
while [ -n "$1" ]; do
  if [ $1 == "-j" ]; then
    shift
    JNDINAME="$1"
    shift
  elif [ $1 == "-p" ]; then
    shift
    FILEPROPERTY="$1"
    shift
  elif [ $1 == "-o" ]; then
    shift
    OUTPUTFILE="$1".rar
    shift
  elif [ $1 == "-d" ]; then
    DEPLOY="true"
    shift
  elif [ $1 == "-l" ]; then
    LEGACY="true"
    shift
  elif [ $1 == "-h" ]; then
    help
    exit 3
  else
    help
    exit 3
  fi
done

#Test JNDI Name
MATCH=`expr match "$JNDINAME" 'service_jmx_rmi____jndi_rmi___[0-9a-zA-Z\.]*_[0-9]*_.*'`
#MATCH=`expr match "$JNDINAME" 'service_jmx_rmi____jndi_rmi___*:[0-9]*_*'`
echo "#   Testing the JNDI name ..."
if [ ! $MATCH == ${#JNDINAME} ]; then
    cecho "#" $red
    cecho "#   Wrong JNDI name : $JNDINAME" $red
    cecho "#" $red
    echo "#############################################################################################"
    exit 4
fi
    echo "#   Test OK"
    echo "#"

#Set input file
if [ -f "jmxadapter_for_jonas.rar" ]; then
  INPUTFILE="jmxadapter_for_jonas.rar"
else
echo "#"
cecho "#   you need to compile the RA and deploy it first" $red
echo "#"
echo "#############################################################################################"
  exit 1
fi

echo "#"
echo "#   Use the following input file :"
echo "#   ${INPUTFILE} "
echo "#"

#Set deploy directory and RAConfig path
if [ -d $JONAS_BASE/deploy ]; then
  DEPLOYDIR=$JONAS_BASE/deploy
elif [ -d $JONAS_BASE/rars ]; then
  DEPLOYDIR=$JONAS_BASE/rars
else
echo "#"
cecho "#   A problem occured when trying to get the deploy directory." $red
cecho "#   Check that JONAS_BASE is set" $red
echo "#"
echo "#############################################################################################"
  exit 2
fi

if [ -f $JONAS_ROOT/bin/RAConfig ]; then
  RACONFIG=$JONAS_ROOT/bin/RAConfig
elif [ -f $JONAS_ROOT/bin/unix/RAConfig ]; then
  RACONFIG=$JONAS_ROOT/bin/unix/RAConfig
else
echo "#"
cecho "#   A problem occured when trying to get the RAConfig script." $red
cecho "#   Check that JONAS_ROOT is set" $red
echo "#"
echo "#############################################################################################"
  exit 2
fi



echo "#"
echo "#   Generating RA ..."
echo "#"
if [ ${LEGACY} == "false" ]; then
  ${RACONFIG} -NEW -r JMXConnectionRA -jndiname ${JNDINAME} -p ${FILEPROPERTY} ${INPUTFILE} ${OUTPUTFILE}
else
  mkdir -p tmp/jmxRA/META-INF/
  touch tmp/jmxRA/META-INF/jonas-ra.xml
  echo "<?xml version=\"1.0\"?>
<jonas-connector xmlns=\"http://www.objectweb.org/jonas/ns\"
               xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"
               xsi:schemaLocation=\"http://www.objectweb.org/jonas/ns
                                   http://www.objectweb.org/jonas/ns/jonas-connector_4_4.xsd\" >
  <rarlink>JMXConnectionRA</rarlink>
  <native-lib></native-lib>
  <log-enabled>false</log-enabled>
  <log-topic></log-topic>
  <pool-params>
    <pool-init>0</pool-init>
    <pool-min>`grep "minconpool" ${FILEPROPERTY} | awk -F "=" '{print $2}'`</pool-min>
    <pool-max>`grep "maxconpool" ${FILEPROPERTY} | awk -F "=" '{print $2}'`</pool-max>
    <pool-max-age-minutes>`grep "connmaxage" ${FILEPROPERTY} | awk -F "=" '{print $2}'`</pool-max-age-minutes>
    <pstmt-max>10</pstmt-max>
    <pool-max-opentime>`grep "maxopentime" ${FILEPROPERTY} | awk -F "=" '{print $2}'`</pool-max-opentime>
    <pool-max-waiters>`grep "maxwaiters" ${FILEPROPERTY} | awk -F "=" '{print $2}'`</pool-max-waiters>
    <pool-max-waittime>`grep "maxwaittime" ${FILEPROPERTY} | awk -F "=" '{print $2}'`</pool-max-waittime>
    <pool-sampling-period>30</pool-sampling-period>
  </pool-params>
  <jdbc-conn-params>
    <jdbc-check-level>0</jdbc-check-level>
  </jdbc-conn-params>
  <jonas-connection-definition>
    <description>org.ow2.jasmine.adapter.jmx.pool.outbound.ManagedConnectionFactoryImpl</description>
    <jndi-name>$JNDINAME</jndi-name>
  </jonas-connection-definition>
</jonas-connector>
" > tmp/jmxRA/META-INF/jonas-ra.xml
 
 # Make the rar file
 jar -cf ${OUTPUTFILE} -C tmp/jmxRA META-INF

 rm -r tmp

fi

if [ $DEPLOY == "true" ]; then
  # Move the RA in the deploy directory
  mv ${OUTPUTFILE} ${DEPLOYDIR}

echo "#"
echo "#	  RA generated and moved into the deploy directory"
echo "#"
cecho "#   Summary :" $green
cecho "#		Property file used : $FILEPROPERTY" $green
cecho "#		RAConfig : $RACONFIG" $green
cecho "#		JNDIName : $JNDINAME" $green
cecho "#		Output file : $OUTPUTFILE" $green
cecho "#		Deploy dir : $DEPLOYDIR" $green
echo "#"
else
echo "#"
echo "#   RA generated ..."
echo "#"
cecho "#   Summary :" $green
cecho "#		Property file used : $FILEPROPERTY" $green
cecho "#		RAConfig : $RACONFIG" $green
cecho "#		JNDIName : $JNDINAME" $green
cecho "#		Output file : $OUTPUTFILE" $green
cecho "#		Deploy dir : RA not deployed, $OUTPUTFILE is in the current directory" $green
echo "#"
fi


echo "#"
echo "#############################################################################################"


