/**
 * JASMINe
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventDetails.java 5150 2009-09-05 10:45:34Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.messages;

import java.io.Serializable;
import java.util.Date;

/**
 * Event details for a {@link JasmineEvent}.
 */
public class JasmineEventDetails implements Serializable {
    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = -3923949369380759691L;

    /**
     * Event source (for example, MBeanCmd or JMX).
     */
    private String source;

    /**
     * Probe type.
     */
    private String probe;

    /**
     * Probed value.
     */
    private String value;

    /**
     * Probe time (precise up to a second).
     */
    private Date timestamp;

    /**
     * JMX url of the probe.
     */
    private String sname;

    /**
     * Constructor: saves the values.
     *
     * @param source     Event source (for example, MBeanCmd or JMX).
     * @param probe      Probe type.
     * @param value      Probed value.
     * @param timestamp  Probe time (precise up to a second).
     */
    public JasmineEventDetails(final String source, final String probe, final String value, final Date timestamp, final String sname) {
        this.source = source;
        this.probe = probe;
        this.value = value;
        this.timestamp = timestamp;
        this.sname = sname;
    }

    /**
     * @return  Event source (for example, MBeanCmd or JMX).
     */
    public String getSource() {
        return source;
    }

    /**
     * @return  Probe type.
     */
    public String getProbe() {
        return probe;
    }

    /**
     * @return  Probed value.
     */
    public String getValue() {
        return value;
    }

    /**
     * @return  Probe time (precise up to a second).
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /**
     * @return JMX url of the probe.
     */
    public String getSname() {
        return sname;
    }
}
