/**
 * JASMINe
 * Copyright (C) 2007-2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventEB.java 6292 2010-04-12 14:51:25Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.beans;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Mirror of the entity bean for a JASMINe Event. This version is not a bean.
 */
public class JasmineEventEB implements Serializable {
    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = 3397185344962128247L;

    /**
     * Saves all information.
     *
     * @param domain     Domain of the probed server.
     * @param server     Name of the probed server.
     * @param source     Event source (for example, MBeanCmd or JMX).
     * @param probe      Probe type.
     * @param value      Probed value.
     * @param timestamp  Probe time (precise up to a second).
     */
    public JasmineEventEB(final String domain, final String server, final String source,
                          final String probe, final Serializable value, final Date timestamp,
                          final String sname) {
        this.domain = domain;
        this.server = server;
        this.source = source;
        this.probe = probe;
        this.value = value;
        this.timestamp = timestamp;
        this.sname = sname;
    }

    /**
     * @return  Domain of the probed server.
     */
    public String getDomain() {
        return domain;
    }

    /**
     * @return  Name of the probed server.
     */
    public String getServer() {
        return server;
    }

    /**
     * @return  Event source (for example, MBeanCmd or JMX).
     */
    public String getSource() {
        return source;
    }

    /**
     * @return  Probe type.
     */
    public String getProbe() {
        return probe;
    }

    /**
     * @return  Probed value.
     */
    public Serializable getValue() {
        return value;
    }

    /**
     * @return  Probe time (precise up to a second).
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /**
     * @return JMX url of the probe.
     */
    public String getSname(){
        return this.sname;
    }

    @Override
    public String toString() {
        return "JasmineEventEB[domain=" + domain
            + ", server=" + server + ", source=" + source
            + ", probe=" + probe + ", value=" + value
            + ", timestamp=" + timestamp + ", sname=" + sname + "]";
    }

    /**
     * @return the CSV format
     */
    public String toCSV() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss" );
        String dateConverted = format.format(this.timestamp);

        return dateConverted + ";" +
               this.timestamp + ";" +
               this.sname + ";" +
               this.server + ";" +
               this.domain + ";" +
               this.source + ";" +
               this.probe + ";" +
               this.value + ";" ;

    }

    /**
     * Domain of the probed server.
     */
    private String domain;

    /**
     * Name of the probed server.
     */
    private String server;

    /**
     * Event source (for example, MBeanCmd or JMX).
     */
    private String source;

    /**
     * Probe type.
     */
    private String probe;

    /**
     * Probed value.
     */
    private Serializable value;

    /**
     * Probe time (precise up to a second).
     */
    private Date timestamp;

    /**
     * JMX url of the probe.
     */
    private String sname;
}
