/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: JasmineEventNotificationMail.java 6292 2010-04-12 14:51:25Z alitokmen $
 */

package org.ow2.jasmine.event.messages;

import java.util.Date;

import org.ow2.jasmine.event.beans.JasmineEventNotification;

/**
 * A Mail notification event.
 */
public class JasmineEventNotificationMail extends JasmineEventNotification {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * the mail source address.
     */
    private String from;

    /**
     * the mail destination address.
     */
    private String to;

    /**
     * the carbon copy.
     */
    private String cc;

    /**
     * the blind carbon copy.
     */
    private String bcc;


    /**
     * default constructor.
     */
    public JasmineEventNotificationMail() {
        super();
    }

    /**
     * @param id
     * @param date
     * @param level
     * @param message
     * @param status
     * @param rule
     * @param from
     * @param to
     */
    public JasmineEventNotificationMail(final String id, final Date date, final String level, final String message,
            final Boolean status, final String rule, final String from, final String to) {
        super(id, date, level, message, status, rule);
        this.from = from;
        this.to = to;
    }

    /**
     * @return the from address.
     */
    public String getFrom() {
        return this.from;
    }

    /**
     * @param from
     *            the from address to set.
     */
    public void setFrom(final String from) {
        this.from = from;
    }

    /**
     * @return the to address.
     */
    public String getTo() {
        return this.to;
    }

    /**
     * @param to
     *            the to address to set.
     */
    public void setTo(final String to) {
        this.to = to;
    }

    /**
     * @return the cc address.
     */
    public String getCc() {
        return this.cc;
    }

    /**
     * @param cc
     *            the cc address to set.
     */
    public void setCc(final String cc) {
        this.cc = cc;
    }

    /**
     * @return the bcc address.
     */
    public String getBcc() {
        return this.bcc;
    }

    /**
     * @param bcc
     *            the bcc address to set.
     */
    public void setBcc(final String bcc) {
        this.bcc = bcc;
    }

}
