/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: JasmineEventTimer.java 6292 2010-04-12 14:51:25Z alitokmen $
 */

package org.ow2.jasmine.event.messages;

import java.io.Serializable;
import java.util.Date;

/**
 * A Purge Timer Configuration event.
 */
public class JasmineEventTimer implements Serializable {

    /**
     * Event to set Purge Timer to delete events from db
     */
    private static final long serialVersionUID = 1L;

    private long maxEntryAge;

    private int maxEntryNumber;

    private Date executionStartDate;

    private int executionStartHours;

    private long executionInterval;

    private boolean immediateExecution;

    private boolean executeOnAllServers;

    private String domainName;

    private String serverName;

    /**
     * default constructor.
     */
    public JasmineEventTimer() {
        super();
    }

    /**
     * @param id
     * @param date
     * @param level
     * @param message
     * @param status
     * @param rule
     * @param from
     * @param to
     */
    public JasmineEventTimer(final String id, final Date date, final String level, final String message, final Boolean status,
        final String rule, final int maxEntryAge, final int maxEntryNumber, final Date executionStartDate,
        final int executionStartHours, final long executionInterval, final boolean immediateExecution,
        final boolean executeOnAllServers, final String domainName, final String serverName) {

        this.maxEntryAge = maxEntryAge;
        this.maxEntryNumber = maxEntryNumber;
        this.executionStartDate = executionStartDate;
        this.executionStartHours = executionStartHours;
        this.executionInterval = executionInterval;
        this.immediateExecution = immediateExecution;
        this.executeOnAllServers = executeOnAllServers;
        this.domainName = domainName;
        this.serverName = serverName;
    }

    public long getMaxEntryAge() {
        return maxEntryAge;
    }

    public void setMaxEntryAge(final long maxEntryAge) {
        this.maxEntryAge = maxEntryAge;
    }

    public int getMaxEntryNumber() {
        return maxEntryNumber;
    }

    public void setMaxEntryNumber(final int maxEntryNumber) {
        this.maxEntryNumber = maxEntryNumber;
    }

    public Date getExecutionStartDate() {
        return executionStartDate;
    }

    public void setExecutionStartDate(final Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    public long getExecutionInterval() {
        return executionInterval;
    }

    public void setExecutionInterval(final long executionInterval) {
        this.executionInterval = executionInterval;
    }

    public boolean isImmediateExecution() {
        return immediateExecution;
    }

    public void setImmediateExecution(final boolean immediateExecution) {
        this.immediateExecution = immediateExecution;
    }

    public boolean isExecuteOnAllServers() {
        return executeOnAllServers;
    }

    public void setExecuteOnAllServers(final boolean executeOnAllServers) {
        this.executeOnAllServers = executeOnAllServers;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(final String domainName) {
        this.domainName = domainName;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(final String serverName) {
        this.serverName = serverName;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    /**
     * @return the executionStartHours
     */
    public int getExecutionStartHours() {
        return executionStartHours;
    }

    /**
     * @param executionStartHours the executionStartHours to set
     */
    public void setExecutionStartHours(final int executionStartHours) {
        this.executionStartHours = executionStartHours;
    }

}
