/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventNotificationUpdate.java 7467 2011-01-20 15:53:43Z renaultgu $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.ow2.jasmine.event.component.SearchFilter;

/**
 * Contains informations to update a stored {@link JasmineEventNotification}.
 * The update will add a {@link JasmineEventNotificationDetail}, or a
 * {@link JasmineEventNotificationExecutedAction}. Filters have to be set to get
 * a unique notification to update.
 *
 * @author Guillaume Renault
 */
public class JasmineEventNotificationUpdate implements Serializable {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = -7505249031966343802L;

    /**
     * the list of filters to apply to find the notification to update.
     */
    private List<SearchFilter> searchFilters;

    /**
     * The detail to add.
     */
    private JasmineEventNotificationDetail detail;

    /**
     * The action to add.
     */
    private JasmineEventNotificationExecutedAction action;

    /**
     * Comment about the update.
     */
    private String comment;

    /**
     * The user who created the update Object. It may be the System itself.
     */
    private String user;

    /**
     * Contains the new rule name for the notification to update.
     */
    private String rule;

    /**
     * Initialize the {@link SearchFilter} list and set the detail to add.
     *
     * @param p_detail the {@link JasmineEventNotificationDetail} to add.
     */
    public JasmineEventNotificationUpdate(final JasmineEventNotificationDetail p_detail) {
        this.searchFilters = new ArrayList<SearchFilter>();
        this.detail = p_detail;
    }

    /**
     * Initialize the {@link SearchFilter} list and set the action to add.
     *
     * @param p_detail the {@link JasmineEventNotificationExecutedAction} to
     *        add.
     */
    public JasmineEventNotificationUpdate(final JasmineEventNotificationExecutedAction p_action) {
        this.searchFilters = new ArrayList<SearchFilter>();
        this.action = p_action;
    }

    /**
     * @return the detail
     */
    public JasmineEventNotificationDetail getDetail() {
        return detail;
    }

    /**
     * @param detail the detail to set
     */
    public final void setDetail(final JasmineEventNotificationDetail detail) {
        this.detail = detail;
    }

    /**
     * @return the action
     */
    public final JasmineEventNotificationExecutedAction getAction() {
        return action;
    }

    /**
     * @param action the action to set
     */
    public final void setAction(final JasmineEventNotificationExecutedAction action) {
        this.action = action;
    }

    /**
     * @return the filters
     */
    public List<SearchFilter> getSearchFilters() {
        return searchFilters;
    }

    /**
     * Add a {@link SearchFilter} to the list.
     *
     * @param searchFilter the {@link SearchFilter} to add.
     */
    public void addSearchFilter(final SearchFilter searchFilter) {
        this.searchFilters.add(searchFilter);
    }

    /**
     * @return the comment
     */
    public final String getComment() {
        return comment;
    }

    /**
     * @param comment the comment to set
     */
    public final void setComment(final String comment) {
        this.comment = comment;
    }

    /**
     * @return the user
     */
    public final String getUser() {
        return user;
    }

    /**
     * @param user the user to set
     */
    public final void setUser(final String user) {
        this.user = user;
    }


    public String getRule()
    {
        return rule;
    }

    public void setRule(String rule)
    {
        this.rule=rule;
    }
}
