/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Route.java 6811 2010-08-26 14:35:48Z ghanmh $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.beans.mediationLayer;

import java.util.List;

/**
 *
 * @author Hicham GHANM
 */
public class Route {

    /**
     * Status of route
     *
     */
    private boolean status;
    /**
     * Name of route
     */
    private String name;
    /**
     * listening on the route
     */
    private boolean audit;
    /**
     * Input endpoint
     */
    private List<EndPoint> inputEndPoint;
    /**
     * Output endpoint
     */
    private List<EndPoint> outputEndPoint;
    /**
     * listening on the route
     */
    private String jmxUrl;

    /**
     * Default constructor
     */
    public Route() {
        super();
    }

    /* ************************************************** */
    /*                Getters and Setters                 */
    /* ************************************************** */
    public boolean isAudit() {
        return audit;
    }

    public void setAudit(final boolean audit) {
        this.audit = audit;
    }

    public List<EndPoint> getInputEndPoint() {
        return inputEndPoint;
    }

    public void setInputEndPoint(final List<EndPoint> inputEndPoint) {
        this.inputEndPoint = inputEndPoint;
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public List<EndPoint> getOutputEndPoint() {
        return outputEndPoint;
    }

    public void setOutputEndPoint(final List<EndPoint> outputEndPoint) {
        this.outputEndPoint = outputEndPoint;
    }

    public boolean isStatus() {
        return status;
    }

    public void setStatus(final boolean status) {
        this.status = status;
    }

    public String getJmxUrl() {
        return jmxUrl;
    }

    public void setJmxUrl(final String jmxUrl) {
        this.jmxUrl = jmxUrl;
    }
}
