/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Server.java 6811 2010-08-26 14:35:48Z ghanmh $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.beans.mediationLayer;

import java.util.List;

/**
 *
 * @author Hicham GHANM
 */
public class Server {

    /**
     * Status of server
     * 1 = Started,
     * 2 = Stopped
     */
    private int status;
    /**
     * id of server
     */
    private String id;
    /**
     * name of server
     */
    private String name;
    /**
     * version of mediation layer containning in server
     */
    private String version;
    /**
     * ip of server
     */
    private String ip;
    /**
     * routes of server
     */
    private List<Route> routes;

    /**
     * Default constructor
     */
    public Server() {
        this.status = 1;
    }

    /****************************************************/
    /*                Getters and Setters               */
    /****************************************************/
    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(final String ip) {
        this.ip = ip;
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public List<Route> getRoutes() {
        return routes;
    }

    public void setRoutes(final List<Route> routes) {
        this.routes = routes;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(final int status) {
        this.status = status;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(final String version) {
        this.version = version;
    }
}
