/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SearchDetailFilter.java 6662 2010-06-18 14:55:28Z renaultgu $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.component;

/**
 * This component allow to search a notification given values stored as details.
 *
 * @author Guillaume Renault
 */
public class SearchDetailFilter extends SearchFilter {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = -6103950308339832238L;

    /**
     * Describes the two statements : key := key AND value := value that will be
     * set to retrieve the notification.
     *
     * @param key the key of the detail.
     * @param value the value of the detail.
     */
    public SearchDetailFilter(final String key, final String value) {
        super();
        this.addFilter("key", key);
        this.addFilter("value", value);
    }

    @Override
    public boolean setDetail() {
        return true;
    }

}
