/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SearchFilter.java 6662 2010-06-18 14:55:28Z renaultgu $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.component;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * Filter to specify to retrieve a notification in the DataBase. Each specified
 * filter will aim at the following statement in the sql query : <b>where</b>
 * {@link SearchFilter#getKey()} <b>=</b> {@link SearchFilter#getValue()}
 *
 * @author Guillaume Renault
 */
public abstract class SearchFilter implements Serializable {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 2246401626839738459L;

    /**
     * Map that contains the mapping between the column and the values to find
     * to get the right notification.
     */
    private Map<String, String> filters;

    /**
     * Whether the value is a detail or not.
     */
    private boolean detail;

    /**
     * Constructor that initializes the Search Filter.
     *
     * @param key The name of the key on which the SQL statement is done.
     * @param value The expected value for the specified key.
     */
    public SearchFilter() {
        this.filters = new HashMap<String, String>();
        this.detail = this.setDetail();
    }

    /**
     * Add filters data the the searchFilter.
     *
     * @param key the column name.
     * @param value the value.
     */
    public void addFilter(final String key, final String value) {
        this.filters.put(key, value);
    }

    /**
     * @return the filters
     */
    public final Map<String, String> getFilters() {
        return filters;
    }

    /**
     * @return the detail
     */
    public boolean isDetail() {
        return this.detail;
    }

    /**
     * @param detail the detail to set
     */
    public abstract boolean setDetail();

}
