/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventNotificationProcessor.java 7495 2011-01-24 09:41:11Z renaultgu $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.processor;

import org.ow2.jasmine.event.api.IJasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotification;

/**
 * Interface to define a processor of JASMINe event notification.
 * @author Jean-Pierre Poutcheu
 * @param <T> Type of processor context
 */
public interface JasmineEventNotificationProcessor < T extends ProcessContext > {

    /**
     * Process a JASMINe event notification by using the given context.
     * @param context a processor context
     * @param event a JASMINe event
     * @throws JasmineEventProcessorException if the processing failed
     */
    void process(T context, IJasmineEventNotification event)
    throws JasmineEventProcessorException;
}
