/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: JasmineEventNotificationDetail.java 6290 2010-04-12 14:50:56Z alitokmen $
 */
package org.ow2.jasmine.event.beans;

import java.io.Serializable;

/**
 * A detail element of a notification
 *
 * @author Guillaume Renault
 */
public class JasmineEventNotificationDetail implements Serializable {

    /**
	 *
	 */
    private static final long serialVersionUID = 1L;

    /**
     * Label of the detail.
     */
    private String label;

    /**
     * Message of the detail.
     */
    private String message;

    /**
     * Empty constructor. Do not remove, used for the binding with the same Flex object.
     */
    public JasmineEventNotificationDetail() {

    }

    /**
     * Constructor of a detail.
     *
     * @param label the label of the detail.
     * @param message the message of the label.
     */
    public JasmineEventNotificationDetail(final String label, final String message) {
        super();
        this.label = label;
        this.message = message;
    }

    /**
     * Get the label of the detail.
     *
     * @return the label.
     */
    public String getLabel() {
        return label;
    }

    /**
     * Get the message of the detail.
     *
     * @return the detail.
     */
    public String getMessage() {
        return message;
    }

    /**
     * Set the label of the detail.
     *
     * @param label
     */
    public void setLabel(final String label) {
        this.label = label;
    }

    /**
     * Set the message of the detail.
     *
     * @param message
     */
    public void setMessage(final String message) {
        this.message = message;
    }

}
