/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EndPoint.java 6811 2010-08-26 14:35:48Z ghanmh $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.beans.mediationLayer;

/**
 *
 * @author Hicham GHANM
 */
public class EndPoint {

    /**
     * Name of endPoint
     */
    private String name;
    /**
     * Address of endPoint
     */
    private String address;
    /**
     * Name of address of endPoint
     */
    private String nameOfAddress;
    /**
     * Number of messages received in this endPoint
     */
    private int countMessagesReceived;
    /**
     * Number of messages routed from this endPoint
     */
    private int countMessagesRouted;
    /**
     * Number of messages not routed from this endPoint
     */
    private int countMessagesNotRouted;
    /**
     * Number of messages caught in this endPoint
     */
    private int countMessagesCaught;

    /**
     * Default constructor
     */
    public EndPoint() {
    }

    /* ************************************************** */
    /*                Getters and Setters                 */
    /* ************************************************** */
    public String getAddress() {
        return address;
    }

    public void setAddress(final String address) {
        this.address = address;
    }

    public int getCountMessagesCaught() {
        return countMessagesCaught;
    }

    public void setCountMessagesCaught(final int countMessagesCaught) {
        this.countMessagesCaught = countMessagesCaught;
    }

    public int getCountMessagesNotRouted() {
        return countMessagesNotRouted;
    }

    public void setCountMessagesNotRouted(final int countMessagesNotRouted) {
        this.countMessagesNotRouted = countMessagesNotRouted;
    }

    public int getCountMessagesReceived() {
        return countMessagesReceived;
    }

    public void setCountMessagesReceived(final int countMessagesReceived) {
        this.countMessagesReceived = countMessagesReceived;
    }

    public int getCountMessagesRouted() {
        return countMessagesRouted;
    }

    public void setCountMessagesRouted(final int countMessagesRouted) {
        this.countMessagesRouted = countMessagesRouted;
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String getNameOfAddress() {
        return nameOfAddress;
    }

    public void setNameOfAddress(final String nameOfAddress) {
        this.nameOfAddress = nameOfAddress;
    }

    public void addMessagesRouted(final int countMessagesRouted) {
        this.countMessagesRouted += countMessagesRouted;
    }

    public void addMessagesReceived(final int countMessagesReceived) {
        this.countMessagesReceived += countMessagesReceived;
    }

    public void addMessagesNotRouted(final int countMessagesNotRouted) {
        this.countMessagesNotRouted += countMessagesNotRouted;
    }
}
