/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: JasmineEventNotification.java 8261 2011-06-07 11:58:18Z jlegrand $
 */
package org.ow2.jasmine.event.beans;

import org.ow2.jasmine.event.api.IJasmineEventNotification;
import org.ow2.jasmine.event.component.SearchFilter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Jean-Pierre Poutcheu
 */
public class JasmineEventNotification implements IJasmineEventNotification,Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * notification id.
     */
    private String id;

    /**
     * notification date.
     */
    private Date date;

    /**
     * notification level.
     */
    private String level;

    /**
     * associated message.
     */
    private String message;

    /**
     * notification status acknowledged or not.
     */
    private Boolean status;

    /**
     * the rule id that caused the notification.
     */
    private String rule;

    /**
     * notification additional informations.
     */
    private List<JasmineEventNotificationDetail> details;

    /**
     * actions executed on the notifications.
     */
    private List<JasmineEventNotificationExecutedAction> actions;

    /**
     * default constructor.
     */
    public JasmineEventNotification() {
        this.details = new ArrayList<JasmineEventNotificationDetail>();
        this.actions = new ArrayList<JasmineEventNotificationExecutedAction>();
    }

    /**
     * @param date
     * @param level
     * @param message
     * @param status
     * @param rule
     */
    public JasmineEventNotification(final String id, final Date date, final String level, final String message,
        final Boolean status, final String rule) {
        this.id = id;
        this.date = date;
        this.level = level;
        this.message = message;
        this.status = status;
        this.rule = rule;
        this.details = new ArrayList<JasmineEventNotificationDetail>();
        this.actions = new ArrayList<JasmineEventNotificationExecutedAction>();
    }

    /**
     * @return the id
     */
    public String getId() {
        return this.id;
    }

    /**
     * @param id the id to set
     */
    public void setId(final String id) {
        this.id = id;
    }

    /**
     * @return the date
     */
    public Date getDate() {
        return this.date;
    }

    /**
     * @param date the date to set
     */
    public void setDate(final Date date) {
        this.date = date;
    }

    /**
     * @return the level
     */
    public String getLevel() {
        return this.level;
    }

    /**
     * @param level the level to set
     */
    public void setLevel(final String level) {
        this.level = level;
    }

    /**
     * @return the message
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * @param message the message to set
     */
    public void setMessage(final String message) {
        this.message = message;
    }

    /**
     * @return the status
     */
    public Boolean getStatus() {
        return this.status;
    }

    /**
     * @param status the status to set
     */
    public void setStatus(final Boolean status) {
        this.status = status;
    }

    /**
     * @return the rule
     */
    public String getRule() {
        return this.rule;
    }

    /**
     * @param rule the rule to set
     */
    public void setRule(final String rule) {
        this.rule = rule;
    }

    /**
     * @return the details
     */
    public List<JasmineEventNotificationDetail> getDetails() {
        return this.details;
    }

    /**
     * @param details the details to set
     */
    public void setDetails(final List<JasmineEventNotificationDetail> details) {
        this.details = details;
    }

    /**
     * @param label the detail label
     * @param message the detail message
     */
    public void addDetail(final String label, final String message) {
        this.details.add(new JasmineEventNotificationDetail(label, message));
    }

    /**
     * @return the actions
     */
    public List<JasmineEventNotificationExecutedAction> getActions() {
        return actions;
    }

    /**
     * @param actions the actions to set
     */
    public void setActions(final List<JasmineEventNotificationExecutedAction> actions) {
        this.actions = actions;
    }

    /**
     * Simply add the given action.
     *
     * @param action
     */
    public void addExecutedActions(final String comment, final String action, final String user, final Date date) {
        this.actions.add(new JasmineEventNotificationExecutedAction(comment, action, date, user));
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JasmineEventNotification : ");
        buffer.append("id = ");
        buffer.append(this.id);
        buffer.append(" ; rule = ");
        buffer.append(this.rule);
        buffer.append(" ; level = ");
        buffer.append(this.level);
        buffer.append(" ; date = ");
        buffer.append(this.date);
        buffer.append(" ; message = ");
        buffer.append(this.message);
        buffer.append(" ; details = [");
        for (JasmineEventNotificationDetail jend : this.details) {
            buffer.append("[");
            buffer.append(jend.getLabel());
            buffer.append(" = ");
            buffer.append(jend.getMessage());
            buffer.append("],");
        }
        buffer.append("]");
        return buffer.toString();
    }

}
