/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: JasmineEventNotificationExecutedAction.java 6290 2010-04-12 14:50:56Z alitokmen $
 */
package org.ow2.jasmine.event.beans;

import java.io.Serializable;
import java.util.Date;

/**
 * JasmineEventNotificationExecutedAction represent an action executed by a user
 * on a notification.
 *
 * @author Guillaume Renault
 */
public class JasmineEventNotificationExecutedAction implements Serializable {

    /**
     * Serial Version UID
     */
    private static final long serialVersionUID = -1323037626160906387L;

    /**
     * Comment for the action.
     */
    private String comment = null;

    /**
     * Name of the executed action.
     */
    private String action = null;

    /**
     * Date of the time action.
     */
    private Date date = null;

    /**
     * The user who executed the action.
     */
    private String user = null;

    /**
     * Default constructor.
     */
    public JasmineEventNotificationExecutedAction() {

    }

    /**
     * @param comment the comment of the action
     * @param action the name of the action
     * @param date the date when the action occurred
     */
    public JasmineEventNotificationExecutedAction(final String comment, final String action, final Date date, final String user) {
        super();
        this.comment = comment;
        this.action = action;
        this.date = date;
        this.user = user;
    }

    /**
     * @return the comment
     */
    public String getComment() {
        return comment;
    }

    /**
     * @param comment the comment to set
     */
    public void setComment(final String comment) {
        this.comment = comment;
    }

    /**
     * @return the action
     */
    public String getAction() {
        return action;
    }

    /**
     * @param action the action to set
     */
    public void setAction(final String action) {
        this.action = action;
    }

    /**
     * @return the date
     */
    public Date getDate() {
        return date;
    }

    /**
     * @param date the date to set
     */
    public void setDate(final Date date) {
        this.date = date;
    }

    /**
     * @return the user
     */
    public String getUser() {
        return user;
    }

    /**
     * @param user the user to set
     */
    public void setUser(final String user) {
        this.user = user;
    }

}
