/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SearchSimpleNotificationFilter.java 6662 2010-06-18 14:55:28Z renaultgu $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.component;

import org.ow2.jasmine.event.beans.JasmineEventNotification;

/**
 * This component allow to search a notification given values stored as natives
 * elements.
 *
 * @author Guillaume Renault
 */
public class SearchSimpleNotificationFilter extends SearchFilter {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 3148916418617662975L;

    /**
     * Describes the statement : columnName := value that will be set to
     * retrieve the notification. The set value must be one of the
     * {@link JasmineEventNotification} elements.
     *
     * @param columnName the columnName corresponding to the place where to find
     *        the specified value.<br/>
     *        Column names could be : <li>id</li> <li>date</li> <li>level</li>
     *        <li>message</li> <li>status</li> <li>rule</li>
     * @param value
     */
    public SearchSimpleNotificationFilter(final String columnName, final String value) {
        super();
        this.addFilter(columnName, value);
    }

    /**
     * @see org.ow2.jasmine.event.component.SearchFilter#setDetail()
     */
    @Override
    public boolean setDetail() {
        return false;
    }

}
