/**
 * JASMINe
 * Copyright (C) 2009-2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: JasmineEventPurgeTask.java 6290 2010-04-12 14:50:56Z alitokmen $
 */

package org.ow2.jasmine.event.messages;

import java.io.Serializable;
import java.util.Date;

/**
 * A Purge Task Configuration event.
 */
public class JasmineEventPurgeTask implements Serializable {

    private static final long serialVersionUID = 1L;

    private long id;

    private long maxEntryAge;

    private int maxEntryNumber;

    private Date executionStartDate;

    private long executionInterval;

    private boolean executeOnAllServers;

    private String domainName;

    private String serverName;

    private boolean started;

    private int removedEvents;

    private Date lastExecutionDate;

    /**
     * Default constructor.
     */
    public JasmineEventPurgeTask() {
        super();
    }

    public long getId() {
        return id;
    }

    public void setId(final long id) {
        this.id = id;
    }

    public long getMaxEntryAge() {
        return maxEntryAge;
    }

    public void setMaxEntryAge(final long maxEntryAge) {
        this.maxEntryAge = maxEntryAge;
    }

    public int getMaxEntryNumber() {
        return maxEntryNumber;
    }

    public void setMaxEntryNumber(final int maxEntryNumber) {
        this.maxEntryNumber = maxEntryNumber;
    }

    public Date getExecutionStartDate() {
        return executionStartDate;
    }

    public void setExecutionStartDate(final Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    public long getExecutionInterval() {
        return executionInterval;
    }

    public void setExecutionInterval(final long executionInterval) {
        this.executionInterval = executionInterval;
    }

    public boolean isExecuteOnAllServers() {
        return executeOnAllServers;
    }

    public void setExecuteOnAllServers(final boolean executeOnAllServers) {
        this.executeOnAllServers = executeOnAllServers;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(final String domainName) {
        this.domainName = domainName;
    }

    public String getServerName() {
        return serverName;
    }

    public void setServerName(final String serverName) {
        this.serverName = serverName;
    }

    public boolean isStarted() {
        return started;
    }

    public void setStarted(final boolean started) {
        this.started = started;
    }

    public int getRemovedEvents() {
        return removedEvents;
    }

    public void setRemovedEvents(final int removedEvents) {
        this.removedEvents = removedEvents;
    }

    public Date getLastExecutionDate() {
        return lastExecutionDate;
    }

    public void setLastExecutionDate(final Date lastExecutionDate) {
        this.lastExecutionDate = lastExecutionDate;
    }

}
