/**
 * JASMINe
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.event.messages;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 * A JASMINe event.
 */
public class JasmineEvent implements Serializable {
    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = -3140370545357738491L;

    /**
     * Domain of the probed server.
     */
    private String domain;

    /**
     * Name of the probed server.
     */
    private String server;

    /**
     * Ident of the probe
     */
    private String probeId;

    /**
     * List of events for that server.
     */
    private List<JasmineEventDetails> events = new LinkedList<JasmineEventDetails>();

    /**
     * @return  Domain of the probed server.
     */
    public String getDomain() {
        return domain;
    }

    /**
     * @param domain  Domain of the probed server.
     */
    public void setDomain(final String domain) {
        this.domain = domain;
    }

    /**
     * @return  Name of the probed server.
     */
    public String getServer() {
        return server;
    }

    /**
     * @param server  Name of the probed server.
     */
    public void setServer(final String server) {
        this.server = server;
    }

    public String getProbeId() {
        return probeId;
    }

    public void setProbeId(String probeId) {
        this.probeId = probeId;
    }

    /**
     * @return  List of events for that server.
     */
    public List<JasmineEventDetails> getEvents() {
        return events;
    }

    /**
     * Creates a new JasmineEventDetails and adds it to the events list.
     *
     * @see JasmineEvent#getEvents()
     *
     * @param source     Event source (for example, MBeanCmd or JMX).
     * @param probe      Probe type.
     * @param value      Probed value.
     * @param timestamp  Probe time (precise up to a second).
     * @param sname      JMX url of the probe.
     */
    public void addEvent(final String source, final String probe, final String value, final Date timestamp, final String sname) {
        this.events.add(new JasmineEventDetails(source, probe, value, timestamp, sname));
    }

}
