/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JMXConnectionFactoryImpl.java 1398 2008-06-10 14:28:31Z renaultgu $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.adapter.jmx.pool.outbound;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;

import org.ow2.jasmine.adapter.jmx.pool.api.IJMXConnectionFactory;
import org.ow2.jasmine.adapter.jmx.pool.api.JMXConnectionParam;

/**
 * Connection Factory. this is the object returned when getting the reference
 * close to the JNDI server name
 *
 * @author Guillaume Renault
 *
 */
public class JMXConnectionFactoryImpl implements IJMXConnectionFactory {

    /**
     *
     */
    private static final long serialVersionUID = -2061073126395847639L;

    /**
     * The connection manager associated to the factory.
     */
    private ConnectionManager connectionManager = null;

    /**
     * The manager of the factory.
     */
    private ManagedConnectionFactoryImpl managedconnectionFactory = null;

    /**
     * Logger.
     */
    private static Logger logger = Logger.getLogger(JMXConnectionFactoryImpl.class.getName());

    /**
     * JNDI reference.
     */
    private Reference ref = null;

    /**
     * Create an instance of the factory.
     *
     * @param mcf the manager of the factory.
     * @param cm the connection manager for the factory.
     */
    public JMXConnectionFactoryImpl(final ManagedConnectionFactoryImpl mcf, final ConnectionManager cm) {
        if (cm == null) {
            this.connectionManager = new ConnectionManagerImpl();
        } else {
            this.connectionManager = cm;
        }
        this.managedconnectionFactory = mcf;
    }

    // ------------------------------------------------------------------------
    // Implementation of the IJmxCnxConnectionFactory interface
    // ------------------------------------------------------------------------

    /**
     * Set the reference of the factory. Automatically called by the RA.
     *
     * @param ref reference to set.
     */
    public void setReference(final Reference ref) {
        logger.log(Level.FINE, "set reference <= " + ref);
        this.ref = ref;
    }

    /**
     * Get the reference.
     *
     * @return the reference of the factory.
     * @throws NamingException if the return value is null.
     */
    public Reference getReference() throws NamingException {
        logger.log(Level.FINE, "get reference => " + this.ref);
        if (this.ref == null) {
            throw new NamingException();
        } else {
            return this.ref;
        }

    }

    /**
     * Gets a new connection using the connection manager.
     *
     * @throws ResourceException generic exception if operation fails due to an
     *             error condition.
     * @return a connection.
     */
    public Connection getConnection() throws ResourceException {

        Connection con = (Connection) this.connectionManager.allocateConnection(this.managedconnectionFactory, null);
        if (con == null) {
            // TODO
            logger.log(Level.SEVERE, "Connection null ...");
        }
        return con;

    }

    /**
     * Gets a new connection using the connection manager.
     *
     * @param spec the specifications of the connection to get.
     * @throws ResourceException generic exception if operation fails due to an
     *             error condition.
     * @return a connection.
     */
    public Connection getConnection(final ConnectionSpec spec) throws ResourceException {

        JMXConnectionParam j = (JMXConnectionParam) spec;

        Connection con = (Connection) this.connectionManager.allocateConnection(this.managedconnectionFactory, j);

        if (con == null) {
            // TODO
            logger.log(Level.SEVERE, "Connection null ...");
        }
        return con;

    }

    /**
     * Not implemented.
     *
     * @throws ResourceException generic exception if operation fails due to an
     *             error condition.
     * @return null as not implemented.
     */
    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        logger.log(Level.WARNING, "not implemented");
        return null;
    }

    /**
     * Not implemented.
     *
     * @throws ResourceException generic exception if operation fails due to an
     *             error condition.
     * @return null as not implemented.
     */
    public RecordFactory getRecordFactory() throws ResourceException {
        logger.log(Level.WARNING, "not implemented");
        return null;
    }

}
