/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConnectionManagerImpl.java 1928 2008-07-30 08:45:19Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.adapter.jmx.pool.outbound;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;

/**
 * The connection Manager. Provides a hook for a resource adapter to pass a
 * connection request to an application server.
 *
 * @author Guillaume Renault
 *
 */
public class ConnectionManagerImpl implements ConnectionManager {

    /**
     *
     */
    private static final long serialVersionUID = -897984061639714209L;

    /**
     * Create an instance.
     */
    public ConnectionManagerImpl() {
        // Do nothing
    }

    /**
     * The method allocateConnection gets called by the resource adapter's
     * connection factory instance. This lets connection factory instance
     * (provided by the resource adapter) pass a connection request to the
     * ConnectionManager instance.
     *
     * The connectionRequestInfo parameter represents information specific to
     * the resource adapter for handling of the connection request.
     *
     * @see javax.resource.spi.ConnectionManager#allocateConnection(ManagedConnectionFactory,
     *      ConnectionRequestInfo)
     * @param mcf used by application server to delegate connection
     *            matching/creation.
     * @param info connection request Information.
     * @return connection handle with an EIS specific connection interface.
     * @throws ResourceException Generic exception.
     */
    public final Object allocateConnection(final ManagedConnectionFactory mcf, final ConnectionRequestInfo info)
            throws ResourceException {
        Logger.getLogger(ConnectionManagerImpl.class.getName()).log(Level.FINE, "allocating ...");
        ManagedConnection mc = mcf.createManagedConnection(null, info);
        return mc.getConnection(null, info);
    }

}
