/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JMXConnectionResourceAdapterImpl.java 1928 2008-07-30 08:45:19Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.adapter.jmx.pool.inbound;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

/**
 * Main class of the RA.
 *
 * @author Guillaume Renault
 *
 */
public class JMXConnectionResourceAdapterImpl implements ResourceAdapter, Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -1520639580678307169L;

    /**
     * Logger.
     */
    private static Logger logger = Logger.getLogger(JMXConnectionResourceAdapterImpl.class.getName());

    /**
     * Start method.
     *
     * @see javax.resource.spi.ResourceAdapter#start(BootstrapContext)
     * @param bootstrapCtx a bootstrap context containing references to useful
     *            facilities that could be used by a resource adapter instance.
     * @throws ResourceAdapterInternalException indicates bootstrap failure. The
     *             resource adapter instance is unusable and must be discarded.
     */
    public final void start(final BootstrapContext bootstrapCtx) throws ResourceAdapterInternalException {
        logger.log(Level.INFO, "JmxcnxResourceAdapter started ...");
    }

    /**
     * Stop method.
     *
     * @see javax.resource.spi.ResourceAdapter#stop()
     */
    public final void stop() {
        logger.log(Level.INFO, "JmxcnxResourceAdapter stoped ...");
    }

    /**
     * Not implemented.
     *
     * @see javax.resource.spi.ResourceAdapter#endpointActivation(MessageEndpointFactory,
     *      ActivationSpec)
     * @param endpointFactory a message endpoint factory instance.
     * @param spec an activation spec JavaBean instance.
     * @throws ResourceException generic exception if operation fails due to an
     *             error condition.
     */
    public final void endpointActivation(final MessageEndpointFactory endpointFactory, final ActivationSpec spec)
            throws ResourceException {
        logger.log(Level.WARNING, "Not implemented");

    }

    /**
     * Not implemented.
     *
     * @see javax.resource.spi.ResourceAdapter#endpointDeactivation(MessageEndpointFactory,
     *      ActivationSpec)
     * @param endpointFactory a message endpoint factory instance.
     * @param spec an activation spec JavaBean instance.
     */
    public final void endpointDeactivation(final MessageEndpointFactory endpointFactory, final ActivationSpec spec) {
        logger.log(Level.WARNING, "Not implemented");

    }

    /**
     * Not implemented.
     *
     * @see javax.resource.spi.ResourceAdapter#getXAResources(ActivationSpec[])
     * @param spec an array of ActivationSpec JavaBeans each of which
     *            corresponds to an deployed endpoint application that was
     *            active prior to the system crash.
     * @return null as this function is not implemented, otherwise an array of
     *         XAResource objects each of which represents a unique resource
     *         manager.
     * @throws ResourceException generic exception if operation fails due to an
     *             error condition.
     */
    public final XAResource[] getXAResources(final ActivationSpec[] spec) throws ResourceException {
        logger.log(Level.WARNING, "Not implemented");
        return null;
    }

}
