/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.adapter.jmx.pool.outbound;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import org.ow2.jasmine.adapter.jmx.pool.api.IJMXConnectionFactory;
import org.ow2.jasmine.adapter.jmx.pool.api.JMXConnectionParam;
import org.ow2.jasmine.adapter.jmx.pool.outbound.ConnectionManagerImpl;
import org.ow2.jasmine.adapter.jmx.pool.outbound.ManagedConnectionFactoryImpl;

public class JMXConnectionFactoryImpl
implements IJMXConnectionFactory {
    private static final long serialVersionUID = -2061073126395847639L;
    private ConnectionManager connectionManager = null;
    private ManagedConnectionFactoryImpl managedconnectionFactory = null;
    private static Logger logger = Logger.getLogger(JMXConnectionFactoryImpl.class.getName());
    private Reference ref = null;

    public JMXConnectionFactoryImpl(ManagedConnectionFactoryImpl mcf, ConnectionManager cm) {
        this.connectionManager = cm == null ? new ConnectionManagerImpl() : cm;
        this.managedconnectionFactory = mcf;
    }

    public void setReference(Reference ref) {
        logger.log(Level.FINE, "set reference <= " + ref);
        this.ref = ref;
    }

    public Reference getReference() throws NamingException {
        logger.log(Level.FINE, "get reference => " + this.ref);
        if (this.ref == null) {
            throw new NamingException();
        }
        return this.ref;
    }

    public Connection getConnection() throws ResourceException {
        Connection con = (Connection)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedconnectionFactory, null);
        if (con == null) {
            logger.log(Level.SEVERE, "Connection null ...");
        }
        return con;
    }

    public Connection getConnection(ConnectionSpec spec) throws ResourceException {
        JMXConnectionParam j = (JMXConnectionParam)spec;
        Connection con = (Connection)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedconnectionFactory, (ConnectionRequestInfo)j);
        if (con == null) {
            logger.log(Level.SEVERE, "Connection null ...");
        }
        return con;
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        logger.log(Level.WARNING, "not implemented");
        return null;
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        logger.log(Level.WARNING, "not implemented");
        return null;
    }
}

