/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.adapter.jmx.pool.outbound;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.ow2.jasmine.adapter.jmx.pool.api.JMXConnectionParam;
import org.ow2.jasmine.adapter.jmx.pool.outbound.JMXConnectionImpl;
import org.ow2.jasmine.adapter.jmx.pool.outbound.ManagedConnectionFactoryImpl;

public class ManagedConnectionImpl
implements ManagedConnection {
    private Set<ConnectionEventListener> cels = null;
    private JMXConnectionImpl connection = null;
    private ManagedConnectionFactoryImpl localMCFI = null;
    private Logger logger = Logger.getLogger(ManagedConnectionImpl.class.getName());

    public ManagedConnectionImpl(ManagedConnectionFactoryImpl mcfi) {
        this.localMCFI = mcfi;
        this.logger.log(Level.FINE, "New managed connection");
        this.cels = new HashSet<ConnectionEventListener>();
    }

    public ManagedConnectionFactoryImpl getLocalMCFI() {
        return this.localMCFI;
    }

    public void signalEvent(int code, Object ch) {
        ConnectionEvent ce = null;
        ce = new ConnectionEvent((ManagedConnection)this, code);
        if (ch != null) {
            ce.setConnectionHandle(ch);
        }
        Iterator<ConnectionEventListener> it = this.cels.iterator();
        block7: while (it.hasNext()) {
            switch (code) {
                case 1: {
                    it.next().connectionClosed(ce);
                    continue block7;
                }
                case 2: {
                    it.next().localTransactionStarted(ce);
                    continue block7;
                }
                case 3: {
                    it.next().localTransactionCommitted(ce);
                    continue block7;
                }
                case 4: {
                    it.next().localTransactionRolledback(ce);
                    continue block7;
                }
                case 5: {
                    it.next().connectionErrorOccurred(ce);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal eventType: " + code);
        }
    }

    public void release(JMXConnectionImpl connectionJMX) {
        if (connectionJMX == this.connection) {
            this.signalEvent(1, connectionJMX);
        }
    }

    public void close(JMXConnectionImpl connectionJMX) {
        try {
            connectionJMX.close();
        }
        catch (ResourceException e) {
            this.logger.log(Level.SEVERE, "Error occured while closing the JMX connection");
        }
        this.signalEvent(1, connectionJMX);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.logger.log(Level.FINE, "Add connection listener");
        this.cels.add(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        this.logger.log(Level.WARNING, "Not implemented.");
    }

    public void cleanup() throws ResourceException {
        this.logger.log(Level.FINE, "cleanup called ...");
        if (this.connection.getState() == JMXConnectionImpl.States.CLOSED) {
            this.connection = null;
        }
    }

    public void destroy() throws ResourceException {
        this.logger.log(Level.FINE, "destroy called ...");
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        JMXConnectionParam j = (JMXConnectionParam)cxRequestInfo;
        Logger.getLogger(ManagedConnectionImpl.class.getName()).log(Level.FINE, "\nget connection ...params : \turl " + j.getUrlJMX() + "\tuser " + j.getUserJMX() + "\tpassword " + j.getPasswordJMX());
        if (this.connection == null) {
            this.connection = new JMXConnectionImpl(this, j);
        }
        this.connection.setState(JMXConnectionImpl.States.GET);
        return this.connection;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        this.logger.log(Level.WARNING, "Not implemented.");
        return null;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        this.logger.log(Level.WARNING, "Not implemented.");
        return null;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.logger.log(Level.WARNING, "Not implemented.");
        return null;
    }

    public XAResource getXAResource() throws ResourceException {
        this.logger.log(Level.WARNING, "Not implemented.");
        return null;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.logger.log(Level.FINE, "Remove connection listener");
        this.cels.remove(listener);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logger.log(Level.WARNING, "Not implemented.");
    }
}

