/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.adapter.jmx.pool.outbound.helper;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLSHelper {
    private JMXServiceURL jmxUrl = null;
    private Map<String, Object> env = null;
    private boolean isWLSUrlFlag = false;
    private static final String pattern = "weblogic.management.mbeanservers.";

    public WLSHelper(JMXServiceURL jmxUrl, Map<String, Object> env) {
        if (WLSHelper.isWLSUrl(jmxUrl)) {
            this.isWLSUrlFlag = true;
            this.jmxUrl = jmxUrl;
            this.env = env;
        }
    }

    public final boolean isWLSUrl() {
        return this.isWLSUrlFlag;
    }

    public JMXServiceURL getIORJmxUrl() throws NamingException, MalformedURLException {
        JMXServiceURL iorurl = null;
        if (this.isWLSUrlFlag) {
            String corbaname = this.getCorbaName();
            InitialContext ctx = new InitialContext();
            Object obj = ctx.lookup(corbaname);
            iorurl = new JMXServiceURL("service:jmx:iiop://localhost/ior/" + obj.toString());
        }
        return iorurl;
    }

    public Map translateCredentials(Map map) {
        if (map != null && !map.containsKey("java.naming.security.principal") && !map.containsKey("java.naming.security.credentials") && map.containsKey("jmx.remote.credentials")) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            newMap.putAll(map);
            String[] cred = (String[])map.get("jmx.remote.credentials");
            newMap.put("java.naming.security.principal", cred[0]);
            newMap.put("java.naming.security.credentials", cred[1]);
            return newMap;
        }
        return map;
    }

    public String getCorbaName() {
        String corbaUrl = null;
        if (!this.isWLSUrlFlag) {
            return null;
        }
        String host = this.jmxUrl.getHost();
        int port = this.jmxUrl.getPort();
        if (host.length() > 0 && port > 0) {
            int pathIx = this.jmxUrl.getURLPath().indexOf(pattern);
            corbaUrl = "corbaname:iiop:1.2@" + host + ":" + port + "#" + this.jmxUrl.getURLPath().substring(pathIx);
        }
        return corbaUrl;
    }

    public static final boolean isWLSUrl(JMXServiceURL jmxUrl) {
        boolean ret = false;
        if (jmxUrl != null) {
            ret = jmxUrl.getURLPath().indexOf(pattern) != -1;
        }
        return ret;
    }

    public static final boolean isWLSUrl(String url) {
        JMXServiceURL jmxUrl = null;
        try {
            jmxUrl = new JMXServiceURL(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return WLSHelper.isWLSUrl(jmxUrl);
    }
}

