/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */
package org.ow2.jasmine.adapter.jmx.pool.outbound.helper;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * @author WAESELYNCK-F
 *
 */
public class WLSHelper {

    public WLSHelper(final JMXServiceURL jmxUrl, final Map<String, Object> env) {
        if (isWLSUrl(jmxUrl)) {
            this.isWLSUrlFlag = true;
            this.jmxUrl = jmxUrl;
            this.env = env;
        }
    }

    public final boolean isWLSUrl() {
        return this.isWLSUrlFlag;
    }

    public JMXServiceURL getIORJmxUrl() throws NamingException, MalformedURLException {
        JMXServiceURL iorurl = null;
        if (this.isWLSUrlFlag) {

            String corbaname = this.getCorbaName();
            Context ctx = new InitialContext();
            Object obj = ctx.lookup(corbaname);
            iorurl=new JMXServiceURL("service:jmx:iiop://localhost/ior/"+obj.toString());
        }
        return iorurl;
    }

    /**
     * Workarround for weblogic. It uses
     * - java.naming.security.principal (Context.SECURITY_PRINCIPAL)
     * - java.naming.security.credentials (Context.SECURITY_CREDENTIALS)
     * whereas the standard expects:
     * - jmx.remote.credentials (JMXConnector.CREDENTIALS)
     * This method translates the "standard" credentials  to that expected by t3
     * @param map
     * @return either the same or an updated map
     */

    @SuppressWarnings("unchecked")
    public Map translateCredentials(final Map map) {

        /*
         * WLS uses Context.SECURITY_PRINCIPAL (java.naming.security.principal)
         * and Context.SECURITY_CREDENTIALS (java.naming.security.credentials)
         * instead of JMXConnector.CREDENTIALS (jmx.remote.credentials)
         *
         * So, translate the Map !
         */
        if (map != null && !map.containsKey(Context.SECURITY_PRINCIPAL) && !map.containsKey(Context.SECURITY_CREDENTIALS)) {
            if (map.containsKey(JMXConnector.CREDENTIALS)) {
                Map newMap = new HashMap();
                newMap.putAll(map);
                String[] cred = (String[]) map.get(JMXConnector.CREDENTIALS);
                newMap.put(Context.SECURITY_PRINCIPAL, cred[0]);
                newMap.put(Context.SECURITY_CREDENTIALS, cred[1]);
                return newMap;
            }
        }
        return map;
    }

    /*
     * Example of WLS URLs:
     * - iiop URL =service:jmx:rmi://myHost:7001/jndi/iiop://myHost:7001/weblogic.management.mbeanservers.runtime
     * - t3 URL =service:jmx:t3://myHost:7001/jndi/weblogic.management.mbeanservers.runtime corba URL =
     * - corbaname:iiop:1.2@myHost:7001#weblogic.management.mbeanservers.runtime
     */

    public String getCorbaName() {
        String corbaUrl = null;
        if (!this.isWLSUrlFlag) return null;
        String host = this.jmxUrl.getHost();
        int port = this.jmxUrl.getPort();
        if ( (host.length() > 0) && (port > 0) ) {
            int pathIx = this.jmxUrl.getURLPath().indexOf(pattern);
            corbaUrl = "corbaname:iiop:1.2@" + host + ":" + port + "#" + this.jmxUrl.getURLPath().substring(pathIx);
        }
        return corbaUrl;
    }

    public static final boolean isWLSUrl(final JMXServiceURL jmxUrl) {
        boolean ret = false;
        if (jmxUrl != null) {
            ret = (jmxUrl.getURLPath().indexOf(pattern) == -1 ? false : true);
        }
        return ret;
    }

    public static final boolean isWLSUrl(final String url) {
        JMXServiceURL jmxUrl = null;
        try {
            jmxUrl = new JMXServiceURL(url);
        } catch (MalformedURLException e) {
            // Nothing to do;
        }
        return isWLSUrl(jmxUrl);
    }

    private JMXServiceURL jmxUrl = null;

    private Map<String, Object> env = null;

    private boolean isWLSUrlFlag = false;

    private static final String pattern = "weblogic.management.mbeanservers.";
}
