/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.adapter.jmx.pool.outbound;

import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import org.ow2.jasmine.adapter.jmx.pool.api.IJMXConnectionServer;
import org.ow2.jasmine.adapter.jmx.pool.api.JMXConnectionParam;
import org.ow2.jasmine.adapter.jmx.pool.outbound.ManagedConnectionImpl;
import org.ow2.jasmine.adapter.jmx.pool.outbound.helper.WLSHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXConnectionImpl
implements IJMXConnectionServer {
    private static final long serialVersionUID = 8347416277267878718L;
    private MBeanServerConnection mbscnx = null;
    private JMXConnector jmxConnector = null;
    private JMXConnectionParam param = null;
    private ManagedConnectionImpl localMCI = null;
    private States state = null;
    private final String defaultURL = "service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas";
    private Logger logger = Logger.getLogger(JMXConnectionImpl.class.getName());

    public JMXConnectionImpl(ManagedConnectionImpl mci, JMXConnectionParam params) {
        this.param = params != null ? params : new JMXConnectionParam(this.defaultURL, null, null);
        this.localMCI = mci;
        this.state = States.GET;
        this.logger.log(Level.FINE, "param for the new connection: " + params.getUrlJMX() + "\t" + params.getUserJMX() + "\t" + params.getPasswordJMX());
    }

    public void release() {
        this.localMCI.release(this);
        this.state = States.RELEASED;
    }

    public States getState() {
        return this.state;
    }

    public void setState(States s) {
        this.state = s;
    }

    public void close() throws ResourceException {
        this.closeJMX();
        this.logger.log(Level.FINE, "close() called ...");
    }

    public Interaction createInteraction() throws ResourceException {
        return null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return null;
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        return null;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.createMBean(className, name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.createMBean(className, name, loaderName);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.createMBean(className, name, params, signature);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.createMBean(className, name, loaderName, params, signature);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        Object att = null;
        try {
            this.connect();
            att = this.mbscnx.getAttribute(name, attribute);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return att;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList attl = new AttributeList();
        try {
            this.connect();
            attl = this.mbscnx.getAttributes(name, attributes);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return attl;
    }

    public String getDefaultDomain() throws IOException {
        String domain = null;
        try {
            this.connect();
            domain = this.mbscnx.getDefaultDomain();
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return domain;
    }

    public String[] getDomains() throws IOException {
        String[] domains = null;
        try {
            this.connect();
            domains = this.mbscnx.getDomains();
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return domains;
    }

    public Integer getMBeanCount() throws IOException {
        Integer count = null;
        try {
            this.connect();
            count = this.mbscnx.getMBeanCount();
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return count;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo mbi = null;
        try {
            this.connect();
            mbi = this.mbscnx.getMBeanInfo(name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return mbi;
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        ObjectInstance oi = null;
        try {
            this.connect();
            oi = this.mbscnx.getObjectInstance(name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return oi;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        Object o = null;
        try {
            this.connect();
            o = this.mbscnx.invoke(name, operationName, params, signature);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return o;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        boolean b = false;
        try {
            this.connect();
            b = this.mbscnx.isInstanceOf(name, className);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return b;
    }

    public boolean isRegistered(ObjectName name) throws IOException {
        boolean b = false;
        try {
            this.connect();
            b = this.mbscnx.isRegistered(name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return b;
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        Set<ObjectInstance> ons = null;
        try {
            this.connect();
            ons = this.mbscnx.queryMBeans(name, query);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        if (ons == null) {
            ons = new LinkedHashSet<ObjectInstance>();
        }
        return ons;
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        Set<ObjectName> ons = null;
        try {
            this.connect();
            ons = this.mbscnx.queryNames(name, query);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        if (ons == null) {
            ons = new LinkedHashSet<ObjectName>();
        }
        return ons;
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.removeNotificationListener(name, listener);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.removeNotificationListener(name, listener);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connect();
            this.mbscnx.removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        try {
            this.connect();
            this.mbscnx.setAttribute(name, attribute);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList attl = new AttributeList();
        try {
            this.connect();
            attl = this.mbscnx.setAttributes(name, attributes);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
        return attl;
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            this.connect();
            this.mbscnx.unregisterMBean(name);
        }
        catch (IOException e) {
            this.analyseException(e);
        }
    }

    public void setMBeanServerConnection(MBeanServerConnection cnx) {
        this.mbscnx = cnx;
    }

    public void connect() throws IOException {
        if (this.mbscnx == null) {
            JMXServiceURL jmxUrl;
            Map<String, Object> env = null;
            if (this.param.getUserJMX() != null && this.param.getPasswordJMX() != null) {
                env = new HashMap<String, Object>(2);
                String[] creds = new String[]{this.param.getUserJMX(), this.param.getPasswordJMX()};
                env.put("jmx.remote.credentials", creds);
            }
            if (this.param.getProtocolProviders() != null) {
                if (env == null) {
                    env = new HashMap(2);
                }
                env.put("jmx.remote.protocol.provider.pkgs", this.param.getProtocolProviders());
            }
            if (WLSHelper.isWLSUrl(jmxUrl = new JMXServiceURL(this.param.getUrlJMX()))) {
                WLSHelper helper = new WLSHelper(jmxUrl, env);
                env = helper.translateCredentials(env);
                try {
                    jmxUrl = helper.getIORJmxUrl();
                }
                catch (NamingException e) {
                    this.logger.log(Level.SEVERE, "Cannot retrieve IOR for JMX URL (" + jmxUrl + ")", e);
                }
            }
            JMXConnector c = JMXConnectorFactory.connect(jmxUrl, env);
            this.mbscnx = c.getMBeanServerConnection();
            this.jmxConnector = c;
        }
    }

    private void analyseException(IOException e) throws IOException {
        boolean toClose = false;
        if (e instanceof ConnectException) {
            toClose = true;
        } else if (e instanceof ConnectIOException) {
            toClose = true;
        } else if (e instanceof UnknownHostException) {
            toClose = true;
        } else {
            String s = e.getMessage();
            if (s.startsWith("javax.naming.NameNotFoundException")) {
                this.logger.log(Level.SEVERE, "Persistent error : " + e.getMessage());
            } else if (s.startsWith("javax.naming.ServiceUnavailableException")) {
                toClose = true;
            } else if (s.startsWith("javax.naming.ConfigurationException")) {
                toClose = true;
            }
        }
        if (toClose) {
            try {
                this.close();
            }
            catch (ResourceException e1) {
                e1.printStackTrace();
            }
        }
        throw e;
    }

    private void closeJMX() {
        if (this.jmxConnector != null) {
            try {
                this.jmxConnector.close();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "FWA closing connector");
            }
        }
        this.mbscnx = null;
        this.state = States.CLOSED;
    }

    public JMXConnectionParam getParam() {
        return this.param;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum States {
        RELEASED,
        GET,
        CLOSED;

    }
}

