/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.mapping;

import java.io.File;
import org.ow2.jasmine.deployme.generated.Topology;
import org.ow2.jasmine.mapping.JasmineModelMapping;
import org.ow2.jasmine.mapping.JasmineModelMappingException;

public class JasmineModelMappingMain {
    public static void main(String[] args) {
        if (args.length == 2) {
            File inputfile = new File(args[0]);
            JasmineModelMapping jasmineModelMapping = new JasmineModelMapping();
            try {
                Topology topology = jasmineModelMapping.mapToTopology(inputfile);
                File xmlTopologyFile = jasmineModelMapping.generateXMLTopology(topology, args[1]);
                System.out.println("\n----------------------------------------------------------------------------------");
                System.out.println("\t EXECUTE SUCCESSFUL");
                System.out.println("----------------------------------------------------------------------------------");
                System.out.println(" " + args[0] + " is successufly mapped from jasmine ecore model to XML Format --> ");
                System.out.println(" Input File: " + inputfile.getAbsolutePath());
                System.out.println(" Output File: " + xmlTopologyFile.getAbsolutePath());
                System.out.println("----------------------------------------------------------------------------------");
            }
            catch (JasmineModelMappingException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\n----------------------------------------------------------------------------------");
            System.out.println("\t EXECUTE FAILURE");
            System.out.println("----------------------------------------------------------------------------------");
            System.out.println(" Argument is missing ---> You must enter 2 arguments:");
            System.out.println(" [1] - the input file(Jasmine ecore model)");
            System.out.println(" [2] - the output file(XML Format)");
            System.out.println("----------------------------------------------------------------------------------");
        }
    }
}

