/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.model.jasmine.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.objectweb.jasmine.jade.service.deployer.DeploymentException;
import org.ow2.jasmine.model.datatype.Port;
import org.ow2.jasmine.model.jasmine.Cluster;
import org.ow2.jasmine.model.jasmine.ClusterContainer;
import org.ow2.jasmine.model.jasmine.Domain;
import org.ow2.jasmine.model.jasmine.JASMINe;
import org.ow2.jasmine.model.jasmine.JASMINeNode;
import org.ow2.jasmine.model.jasmine.JASMINeNodeStatus;
import org.ow2.jasmine.model.jasmine.JasmineFactory;
import org.ow2.jasmine.model.jasmine.JasminePackage;
import org.ow2.jasmine.model.jasmine.Server;
import org.ow2.jasmine.model.jasmine.ServerPool;
import org.ow2.jasmine.model.jasmine.impl.ClusterContainerImpl;
import org.ow2.jasmine.model.jasmine.impl.ClusterImpl;
import org.ow2.jasmine.model.jasmine.impl.DomainImpl;
import org.ow2.jasmine.model.jasmine.impl.JASMINeImpl;
import org.ow2.jasmine.model.jasmine.impl.JASMINeNodeImpl;
import org.ow2.jasmine.model.jasmine.impl.ServerImpl;
import org.ow2.jasmine.model.jasmine.impl.ServerPoolImpl;

public class JasmineFactoryImpl
extends EFactoryImpl
implements JasmineFactory {
    public static JasmineFactory init() {
        try {
            JasmineFactory theJasmineFactory = (JasmineFactory)EPackage.Registry.INSTANCE.getEFactory("http:///jasmine.ow2.org/ecore/jasmine");
            if (theJasmineFactory != null) {
                return theJasmineFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new JasmineFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createJASMINe();
            }
            case 1: {
                return this.createServerPool();
            }
            case 2: {
                return this.createServer();
            }
            case 3: {
                return this.createJASMINeNode();
            }
            case 4: {
                return this.createDomain();
            }
            case 5: {
                return this.createCluster();
            }
            case 8: {
                return this.createClusterContainer();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.createJASMINeNodeStatusFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createInetAddressFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createPortFromString(eDataType, initialValue);
            }
            case 15: {
                return this.createDeploymentExceptionFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return this.convertJASMINeNodeStatusToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertInetAddressToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertPortToString(eDataType, instanceValue);
            }
            case 15: {
                return this.convertDeploymentExceptionToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public JASMINe createJASMINe() {
        JASMINeImpl jasmiNe = new JASMINeImpl();
        return jasmiNe;
    }

    public ServerPool createServerPool() {
        ServerPoolImpl serverPool = new ServerPoolImpl();
        return serverPool;
    }

    public Server createServer() {
        ServerImpl server = new ServerImpl();
        return server;
    }

    public JASMINeNode createJASMINeNode() {
        JASMINeNodeImpl jasmiNeNode = new JASMINeNodeImpl();
        return jasmiNeNode;
    }

    public Domain createDomain() {
        DomainImpl domain = new DomainImpl();
        return domain;
    }

    public Cluster createCluster() {
        ClusterImpl cluster = new ClusterImpl();
        return cluster;
    }

    public ClusterContainer createClusterContainer() {
        ClusterContainerImpl clusterContainer = new ClusterContainerImpl();
        return clusterContainer;
    }

    public JASMINeNodeStatus createJASMINeNodeStatusFromString(EDataType eDataType, String initialValue) {
        JASMINeNodeStatus result = JASMINeNodeStatus.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertJASMINeNodeStatusToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public InetAddress createInetAddressFromString(EDataType eDataType, String initialValue) {
        return JasmineFactoryImpl.getIpFromString(initialValue);
    }

    public String convertInetAddressToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        String address = ((InetAddress)instanceValue).toString();
        StringTokenizer st = new StringTokenizer(address, "/");
        return JasmineFactoryImpl.getNextToken(st);
    }

    public Port createPortFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : (initialValue.equals("") ? null : new Port(Integer.parseInt(initialValue)));
    }

    public String convertPortToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public DeploymentException createDeploymentExceptionFromString(EDataType eDataType, String initialValue) {
        return (DeploymentException)super.createFromString(eDataType, initialValue);
    }

    public String convertDeploymentExceptionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public JasminePackage getJasminePackage() {
        return (JasminePackage)this.getEPackage();
    }

    @Deprecated
    public static JasminePackage getPackage() {
        return JasminePackage.eINSTANCE;
    }

    private static InetAddress getIpFromString(String address) {
        try {
            return address == null ? null : (address.equals("") ? null : InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("The value '" + address + "' is not a valid IP address");
        }
    }

    private static String getNextToken(StringTokenizer st) {
        String value = "";
        try {
            value = st.nextToken();
            if (value.equals("\\/")) {
                return "";
            }
            st.nextToken();
            return value;
        }
        catch (NoSuchElementException nsee) {
            return value;
        }
    }
}

