/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.model.javaee;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JDBCCheckLevel implements Enumerator
{
    NO_CHECK(0, "NO_CHECK", "NO_CHECK"),
    STILL_OPEN(1, "STILL_OPEN", "STILL_OPEN"),
    SEND_TEST_BEFORE(2, "SEND_TEST_BEFORE", "SEND_TEST_BEFORE"),
    KEEP_ALIVE_FEATURE(3, "KEEP_ALIVE_FEATURE", "KEEP_ALIVE_FEATURE");

    public static final int NO_CHECK_VALUE = 0;
    public static final int STILL_OPEN_VALUE = 1;
    public static final int SEND_TEST_BEFORE_VALUE = 2;
    public static final int KEEP_ALIVE_FEATURE_VALUE = 3;
    private static final JDBCCheckLevel[] VALUES_ARRAY;
    public static final List<JDBCCheckLevel> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static JDBCCheckLevel get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            JDBCCheckLevel result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static JDBCCheckLevel getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            JDBCCheckLevel result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static JDBCCheckLevel get(int value) {
        switch (value) {
            case 0: {
                return NO_CHECK;
            }
            case 1: {
                return STILL_OPEN;
            }
            case 2: {
                return SEND_TEST_BEFORE;
            }
            case 3: {
                return KEEP_ALIVE_FEATURE;
            }
        }
        return null;
    }

    private JDBCCheckLevel(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new JDBCCheckLevel[]{NO_CHECK, STILL_OPEN, SEND_TEST_BEFORE, KEEP_ALIVE_FEATURE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

