/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.mapping;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.impl.NotationPackageImpl;
import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.Topology;
import org.ow2.jasmine.deployme.generated.WebConf;
import org.ow2.jasmine.mapping.JasmineModelMappingException;
import org.ow2.jasmine.model.jasmine.Cluster;
import org.ow2.jasmine.model.jasmine.Domain;
import org.ow2.jasmine.model.jasmine.JasminePackage;
import org.ow2.jasmine.model.jasmine.ManagedElement;
import org.ow2.jasmine.model.jasmine.impl.JasminePackageImpl;
import org.ow2.jasmine.model.javaee.AJP;
import org.ow2.jasmine.model.javaee.CMI;
import org.ow2.jasmine.model.javaee.DataBase;
import org.ow2.jasmine.model.javaee.HTTP;
import org.ow2.jasmine.model.javaee.HTTPS;
import org.ow2.jasmine.model.javaee.IIOP;
import org.ow2.jasmine.model.javaee.IJavaEEServer;
import org.ow2.jasmine.model.javaee.IRMI;
import org.ow2.jasmine.model.javaee.IRMIRegistry;
import org.ow2.jasmine.model.javaee.IWebConnector;
import org.ow2.jasmine.model.javaee.JDBCConfiguration;
import org.ow2.jasmine.model.javaee.JRMP;
import org.ow2.jasmine.model.jonas.JOnAS;
import org.ow2.jasmine.model.jonas4.JOnAS4;
import org.ow2.jasmine.model.jonas5.JOnAS5;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasmineModelMapping {
    private Marshaller marshaller;

    private void initMarshall() {
        if (this.marshaller == null) {
            try {
                JAXBContext jc = JAXBContext.newInstance((String)Topology.class.getPackage().getName());
                this.marshaller = jc.createMarshaller();
                this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
    }

    public Topology mapToTopology(List<Domain> EcoreDomains) throws JasmineModelMappingException {
        Topology topology = new Topology();
        Topology.Domains domains = new Topology.Domains();
        for (Domain domain : EcoreDomains) {
            String domainName = null;
            Topology.Domains.Domain topologyDomain = new Topology.Domains.Domain();
            Topology.Domains.Domain.Servers servers = new Topology.Domains.Domain.Servers();
            for (ManagedElement managementElement : domain.getManagedElements()) {
                Topology.Domains.Domain.Servers.Server server = new Topology.Domains.Domain.Servers.Server();
                if (managementElement instanceof JOnAS) {
                    JOnAS jonas = (JOnAS)managementElement;
                    domainName = jonas.getDomain();
                    server.setName(jonas.getName());
                    server.setConfiguration(this.mapJonasConfiguration(jonas));
                    if (jonas.getJasmineNode() != null) {
                        server.setMachine(jonas.getJasmineNode().getName());
                    }
                }
                servers.getServer().add(server);
            }
            topologyDomain.setName(domainName);
            topologyDomain.setServers(servers);
            domains.getDomain().add(topologyDomain);
            topology.setDomains(domains);
            topology.setMachines(new Topology.Machines());
            topology.setApplications(new Topology.Applications());
        }
        return topology;
    }

    public Topology mapToTopology(String EcoreJasmineFileData) throws JasmineModelMappingException {
        return this.mapToTopology(this.loadDomain(EcoreJasmineFileData));
    }

    public Topology mapToTopology(File EcoreJasmineDomainFile) throws JasmineModelMappingException {
        return this.mapToTopology(this.loadDomain(EcoreJasmineDomainFile));
    }

    public List<Domain> loadDomain(String EcoreJasmineFileData) throws JasmineModelMappingException {
        ArrayList<Domain> domains = new ArrayList();
        File tempFile = null;
        try {
            tempFile = File.createTempFile("default.jasminemodel", ".tmp");
            PrintWriter printWriter = new PrintWriter(tempFile);
            printWriter.write(EcoreJasmineFileData);
            printWriter.close();
        }
        catch (IOException e) {
            throw new JasmineModelMappingException("probleme in creation temporary File", null);
        }
        domains = this.loadDomain(tempFile);
        tempFile.delete();
        return domains;
    }

    public List<Domain> loadDomain(File EcoreJasmineFile) throws JasmineModelMappingException {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        JasminePackage ePackage = JasminePackageImpl.eINSTANCE;
        NotationPackage notationPackage = NotationPackageImpl.eINSTANCE;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
        resourceSet.getPackageRegistry().put((Object)notationPackage.getNsURI(), (Object)notationPackage);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)EcoreJasmineFile.getAbsolutePath());
        Resource resource = resourceSet.getResource(fileURI, true);
        for (EObject eObject : resource.getContents()) {
            if (!(eObject instanceof Domain)) continue;
            domains.add((Domain)eObject);
        }
        return domains;
    }

    public String generateXMLTopology(Topology topology) {
        String XMLTopology = "";
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.initMarshall();
        try {
            this.marshaller.marshal((Object)topology, (OutputStream)outputStream);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        XMLTopology = outputStream.toString();
        return XMLTopology;
    }

    public File generateXMLTopology(Topology topology, String fileName) {
        File file = new File(fileName);
        this.generateXMLTopology(topology, file);
        return file;
    }

    public void generateXMLTopology(Topology topology, File file) {
        this.initMarshall();
        try {
            this.marshaller.marshal((Object)topology, file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private Configuration mapJonasConfiguration(JOnAS jonas) {
        Configuration configuration = new Configuration();
        configuration.setActiveServices(this.mapActiveServices(jonas));
        configuration.setGlobalJonas(this.mapGlobalJonas(jonas));
        configuration.setEjbClustering(this.mapEjbClustering(jonas));
        configuration.setJdbc(this.mapJdbc(jonas));
        configuration.setJms(this.mapJms(jonas));
        configuration.setProtocols(this.mapProtocols(jonas));
        configuration.setSecurityManager(this.mapSecurityManager(jonas));
        return configuration;
    }

    private Configuration.Protocols mapProtocols(IJavaEEServer javaEEServer) {
        Configuration.Protocols protocols = new Configuration.Protocols();
        String protocolList = "";
        String protocol = "";
        for (IRMIRegistry rmiRegistry : javaEEServer.getRmiRegistries()) {
            if (rmiRegistry instanceof JRMP) {
                JRMP jrmp = (JRMP)rmiRegistry;
                protocols.setJrmpPort(BigInteger.valueOf(jrmp.getServerPort().longValue()));
                protocols.setJndiLocalCallOptimization(Boolean.valueOf(jrmp.isLocalCall()));
                protocol = "jrmp";
            } else if (rmiRegistry instanceof IIOP) {
                IIOP iiop = (IIOP)rmiRegistry;
                protocols.setIiopPort(BigInteger.valueOf(iiop.getServerPort().longValue()));
                protocol = "iiop,";
            } else if (rmiRegistry instanceof CMI) {
                protocolList = "cmi";
            } else if (rmiRegistry instanceof IRMI) {
                IRMI irmi = (IRMI)rmiRegistry;
                protocol = "irmi";
                protocols.setIrmiPort(BigInteger.valueOf(irmi.getServerPort().longValue()));
            }
            protocolList = protocol + ",";
        }
        if (protocolList.length() > 0) {
            protocolList = protocolList.substring(0, protocolList.length() - 1);
            protocols.setProtocolsList(protocolList);
        }
        return protocols;
    }

    private Configuration.GlobalJonas mapGlobalJonas(JOnAS jonas) {
        Configuration.GlobalJonas globalJonas = new Configuration.GlobalJonas();
        globalJonas.setJonasBase(jonas.getJonasRoot());
        globalJonas.setJonasRoot(jonas.getJonasRoot());
        globalJonas.setHost(jonas.getIpAddress().getHostAddress());
        if (jonas.getJavaEnvironment() != null) {
            globalJonas.setJdk(jonas.getJavaEnvironment().getJDKPath());
            String JavaOpts = "";
            for (String javaStandardOpts : jonas.getJavaEnvironment().getStandardOptions()) {
                JavaOpts = JavaOpts + javaStandardOpts + " ";
            }
            for (String javaNoStandardOpts : jonas.getJavaEnvironment().getNoStandardOptions()) {
                JavaOpts = JavaOpts + javaNoStandardOpts + " ";
            }
            globalJonas.setJavaOpts(JavaOpts);
        }
        if (jonas instanceof JOnAS4) {
            globalJonas.setJonasVersion(((JOnAS4)jonas).getVersion().getName());
        } else if (jonas instanceof JOnAS5) {
            globalJonas.setJonasVersion(((JOnAS5)jonas).getVersion().getName());
        }
        return globalJonas;
    }

    private Configuration.ActiveServices mapActiveServices(IJavaEEServer server) {
        Configuration.ActiveServices activeServices = new Configuration.ActiveServices();
        activeServices.setDb(this.mapDbService(server));
        activeServices.setDiscovery(this.mapDiscoveryService(server));
        if (server instanceof JOnAS) {
            JOnAS jonas = (JOnAS)server;
            activeServices.setHa(this.mapHaService(jonas));
            activeServices.setMail(this.mapMailService(jonas));
            activeServices.setWeb(this.mapWebService(jonas));
            activeServices.setWs(this.mapWsService(jonas));
        }
        return activeServices;
    }

    private Configuration.ActiveServices.Mail mapMailService(JOnAS jonas) {
        Configuration.ActiveServices.Mail mail = new Configuration.ActiveServices.Mail();
        if (jonas.getServiceMail() != null) {
            mail.setFactoryName(jonas.getServiceMail().getFactoryName());
            mail.setFactoryType(jonas.getServiceMail().getFactoryType().getName());
        }
        return mail;
    }

    private Configuration.ActiveServices.Ws mapWsService(JOnAS jonas) {
        Configuration.ActiveServices.Ws ws = new Configuration.ActiveServices.Ws();
        if (jonas.getServiceWS() != null) {
            ws.setWsdlFileDir(jonas.getServiceWS().getWSDLFiledir());
            ws.setWsdlFilename(jonas.getServiceWS().getWSDLFilename());
        }
        return ws;
    }

    private Configuration.ActiveServices.Db mapDbService(IJavaEEServer javaEEServer) {
        Configuration.ActiveServices.Db db = new Configuration.ActiveServices.Db();
        if (javaEEServer.getDataBases() != null && javaEEServer.getDataBases().size() > 0) {
            db.setPort(BigInteger.valueOf(((DataBase)javaEEServer.getDataBases().get(0)).getPort()));
        }
        return db;
    }

    private Configuration.ActiveServices.Discovery mapDiscoveryService(IJavaEEServer javaEEServer) {
        Configuration.ActiveServices.Discovery discovery = new Configuration.ActiveServices.Discovery();
        if (javaEEServer.getDiscoveryServices() != null) {
            discovery.setGreetingPort(BigInteger.valueOf(javaEEServer.getDiscoveryServices().getGreetingPort().longValue()));
            discovery.setMulticastAddress(javaEEServer.getDiscoveryServices().getMulticastAddress().getHostAddress());
            discovery.setMulticastPort(BigInteger.valueOf(javaEEServer.getDiscoveryServices().getMulticastPort().longValue()));
            discovery.setSourcePort(BigInteger.valueOf(javaEEServer.getDiscoveryServices().getSourcePort().longValue()));
            discovery.setSourcePort(BigInteger.valueOf(javaEEServer.getDiscoveryServices().getSourcePort().longValue()));
            discovery.setTtl(new Integer(javaEEServer.getDiscoveryServices().getTtl()).toString());
        }
        return discovery;
    }

    private Configuration.ActiveServices.Ha mapHaService(JOnAS jonas) {
        Configuration.ActiveServices.Ha ha = new Configuration.ActiveServices.Ha();
        if (jonas.getHaGroup() != null) {
            ha.setHaActivated(Boolean.valueOf(true));
            ha.setMulticastPort(BigInteger.valueOf(jonas.getHaGroup().getMulticastPort().longValue()));
            ha.setMulticastAddr(jonas.getHaGroup().getMulticastHost().getHostAddress());
        }
        return ha;
    }

    private Configuration.ActiveServices.Web mapWebService(IJavaEEServer javaEEServer) {
        Configuration.ActiveServices.Web web = new Configuration.ActiveServices.Web();
        if (javaEEServer.getWebContainers() != null) {
            web.setJvmRoute(javaEEServer.getWebContainers().getJvmRoute());
        }
        for (IWebConnector Webconnector : javaEEServer.getWebconnectors()) {
            WebConf webConf = new WebConf();
            webConf.setPort(BigInteger.valueOf(Webconnector.getPort().longValue()));
            if (Webconnector instanceof AJP) {
                web.setAjpActivated(Boolean.valueOf(true));
                Configuration.ActiveServices.Web.AjpConf ajp = new Configuration.ActiveServices.Web.AjpConf();
                ajp.setWebConf(webConf);
                web.setAjpConf(ajp);
                continue;
            }
            if (Webconnector instanceof HTTP) {
                Configuration.ActiveServices.Web.HttpConf http = new Configuration.ActiveServices.Web.HttpConf();
                http.setWebConf(webConf);
                web.setHttpConf(http);
                continue;
            }
            if (!(Webconnector instanceof HTTPS)) continue;
            web.setHttpsActivated(Boolean.valueOf(true));
            Configuration.ActiveServices.Web.HttpsConf https = new Configuration.ActiveServices.Web.HttpsConf();
            https.setWebConf(webConf);
            web.setHttpsConf(https);
        }
        if (javaEEServer instanceof JOnAS) {
            JOnAS jonas = (JOnAS)javaEEServer;
            Configuration.ActiveServices.Web.HttpReplicationConf httpReplicationConf = new Configuration.ActiveServices.Web.HttpReplicationConf();
            if (jonas.getHttpReplicationGroup() != null) {
                web.setHttpReplicationActivated(Boolean.valueOf(true));
                httpReplicationConf.setListenport(BigInteger.valueOf(jonas.getHttpReplicationGroup().getTcpListenPort().longValue()));
                httpReplicationConf.setMcastaddre(jonas.getHttpReplicationGroup().getHost().getHostAddress());
                httpReplicationConf.setMcastport(BigInteger.valueOf(jonas.getHttpReplicationGroup().getPort().longValue()));
                if (jonas.getClusters() != null && jonas.getClusters().size() > 0) {
                    httpReplicationConf.setClusterName(((Cluster)jonas.getClusters().get(0)).getName());
                }
            }
            web.setHttpReplicationConf(httpReplicationConf);
        }
        return web;
    }

    private Configuration.Jdbc mapJdbc(IJavaEEServer javaEEServer) {
        Configuration.Jdbc jdbc = new Configuration.Jdbc();
        for (DataBase db : javaEEServer.getDataBases()) {
            jdbc.setDrivers(db.getDriverName());
            jdbc.setJndiname(db.getJndiName());
            jdbc.setMappername(db.getMappernName());
            jdbc.setPassword(db.getPassword());
            jdbc.setUrl(db.getUrl());
            jdbc.setUser(new Integer(db.getPort()).toString());
        }
        for (org.ow2.jasmine.model.javaee.Resource resource : javaEEServer.getResources()) {
            if (!(resource instanceof JDBCConfiguration)) continue;
            JDBCConfiguration jdbcConfiguration = (JDBCConfiguration)resource;
            jdbc.setJdbcCheckLevel(jdbcConfiguration.getJdbcCheckLevel().getName());
            Configuration.Jdbc.PoolParameters poolParameters = new Configuration.Jdbc.PoolParameters();
            poolParameters.setPoolInit(BigInteger.valueOf(jdbcConfiguration.getPoolInitSize().intValue()));
            poolParameters.setPoolMax(BigInteger.valueOf(jdbcConfiguration.getPoolMaxSize().intValue()));
            poolParameters.setPoolMaxAgeMinutes(BigInteger.valueOf(jdbcConfiguration.getPoolMaxAgeMinutes().intValue()));
            poolParameters.setPoolMaxOpentime(BigInteger.valueOf(jdbcConfiguration.getPoolMaxOpentime().intValue()));
            poolParameters.setPoolMaxWaiters(BigInteger.valueOf(jdbcConfiguration.getPoolMaxWaiters().intValue()));
            poolParameters.setPoolMaxWaittime(BigInteger.valueOf(jdbcConfiguration.getPoolMaxWaitTime().intValue()));
            poolParameters.setPoolMin(BigInteger.valueOf(jdbcConfiguration.getPoolMinSize().intValue()));
            poolParameters.setPoolSamplingPeriod(BigInteger.valueOf(jdbcConfiguration.getPoolSamplingPeriod().intValue()));
            poolParameters.setPstmtMax(BigInteger.valueOf(jdbcConfiguration.getPreparedStatementsMax().intValue()));
            jdbc.setPoolParameters(poolParameters);
        }
        return jdbc;
    }

    private Configuration.Jms mapJms(IJavaEEServer javaEEServer) {
        Configuration.Jms jms = new Configuration.Jms();
        jms.setPort(BigInteger.valueOf(javaEEServer.getJmsServices().getJmsPort().longValue()));
        if (javaEEServer.getJmsServices() != null) {
            String jmsQueues = "";
            for (String jmsQueue : javaEEServer.getJmsServices().getJmsQueues()) {
                jmsQueues = jmsQueues + jmsQueue + ",";
            }
            if (jmsQueues.length() > 0) {
                jmsQueues = jmsQueues.substring(0, jmsQueues.length() - 1);
                jms.setQueue(jmsQueues);
            }
            String jmsTopics = "";
            for (String jmsTopic : javaEEServer.getJmsServices().getJmsTopics()) {
                jmsTopics = jmsTopics + jmsTopic + ",";
            }
            if (jmsTopics.length() > 1) {
                jmsTopics = jmsTopics.substring(0, jmsTopics.length() - 1);
                jms.setTopic(jmsTopics);
            }
        }
        return jms;
    }

    private Configuration.EjbClustering mapEjbClustering(JOnAS jonas) {
        Configuration.EjbClustering ejbClustering = new Configuration.EjbClustering();
        if (jonas.getCmigroup() != null) {
            ejbClustering.isEjbClusteringActivated();
            ejbClustering.setMulticastAddr(jonas.getCmigroup().getMulticastHost().getHostAddress());
            ejbClustering.setMulticastPort(BigInteger.valueOf(jonas.getCmigroup().getMulticastPort().longValue()));
        }
        return ejbClustering;
    }

    private Configuration.SecurityManager mapSecurityManager(JOnAS jonas) {
        Configuration.SecurityManager securityManager = new Configuration.SecurityManager();
        securityManager.setActivation(Boolean.valueOf(jonas.isActivationSecurityManager()));
        return securityManager;
    }
}

