/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.model.jasmine.impl;

import java.net.InetAddress;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.objectweb.jasmine.jade.application.Application;
import org.objectweb.jasmine.jade.application.ApplicationIfc;
import org.objectweb.jasmine.jade.application.ApplicationImpl;
import org.objectweb.jasmine.jade.service.deployer.DeploymentException;
import org.ow2.jasmine.model.jasmine.JASMINeNode;
import org.ow2.jasmine.model.jasmine.JASMINeNodeStatus;
import org.ow2.jasmine.model.jasmine.JasminePackage;
import org.ow2.jasmine.model.jasmine.MiddlewareComponent;

public abstract class MiddlewareComponentImpl
extends EObjectImpl
implements MiddlewareComponent {
    protected JASMINeNode jasmineNode;
    protected static final JASMINeNodeStatus STATUS_EDEFAULT = JASMINeNodeStatus.UNDEPLOYED;
    protected JASMINeNodeStatus status = STATUS_EDEFAULT;
    private Application apps;

    protected MiddlewareComponentImpl() {
    }

    protected EClass eStaticClass() {
        return JasminePackage.Literals.MIDDLEWARE_COMPONENT;
    }

    public JASMINeNode getJasmineNode() {
        if (this.jasmineNode != null && this.jasmineNode.eIsProxy()) {
            InternalEObject oldJasmineNode = (InternalEObject)this.jasmineNode;
            this.jasmineNode = (JASMINeNode)this.eResolveProxy(oldJasmineNode);
            if (this.jasmineNode != oldJasmineNode && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldJasmineNode, (Object)this.jasmineNode));
            }
        }
        return this.jasmineNode;
    }

    public JASMINeNode basicGetJasmineNode() {
        return this.jasmineNode;
    }

    public void setJasmineNode(JASMINeNode newJasmineNode) {
        JASMINeNode oldJasmineNode = this.jasmineNode;
        this.jasmineNode = newJasmineNode;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldJasmineNode, (Object)this.jasmineNode));
        }
    }

    public JASMINeNodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(JASMINeNodeStatus newStatus) {
        JASMINeNodeStatus oldStatus = this.status;
        JASMINeNodeStatus jASMINeNodeStatus = this.status = newStatus == null ? STATUS_EDEFAULT : newStatus;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldStatus, (Object)this.status));
        }
    }

    public void deploy() throws DeploymentException {
        String address = this.getJasmineNode().getName();
        String instance_home = this.getInstanceHome();
        String nodeId = this.getNodeId();
        try {
            ((ApplicationIfc)((Object)this.getApp())).deploy(address, instance_home, nodeId);
            try {
                this.setStatus(JASMINeNodeStatus.STOPPED);
            }
            catch (IllegalStateException ignored) {}
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void start() throws DeploymentException {
        try {
            ApplicationImpl dep = (ApplicationImpl)this.getApp();
            dep.setAttribute("install-dir", this.getInstanceHome());
            this.configure();
            ((ApplicationImpl)this.getApp()).start();
            try {
                this.setStatus(JASMINeNodeStatus.STARTED);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void stop() throws DeploymentException {
        try {
            ((ApplicationImpl)this.getApp()).stop();
            try {
                this.setStatus(JASMINeNodeStatus.STOPPED);
            }
            catch (IllegalStateException ignored) {}
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public abstract void configure() throws DeploymentException;

    public InetAddress getIpAddress() {
        try {
            return this.jasmineNode.getHost();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String getNodeId() {
        try {
            return this.jasmineNode.getNodeId().toString();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public abstract String getInstanceHome();

    public Application getApp() {
        return this.apps;
    }

    public void setApp(Application app) {
        this.apps = app;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getJasmineNode();
                }
                return this.basicGetJasmineNode();
            }
            case 1: {
                return this.getStatus();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setJasmineNode((JASMINeNode)newValue);
                return;
            }
            case 1: {
                this.setStatus((JASMINeNodeStatus)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setJasmineNode(null);
                return;
            }
            case 1: {
                this.setStatus(STATUS_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.jasmineNode != null;
            }
            case 1: {
                return this.status != STATUS_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (status: ");
        result.append((Object)this.status);
        result.append(')');
        return result.toString();
    }
}

