/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.model.javaee;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatabaseProvider implements Enumerator
{
    HSQL(0, "HSQL", "HSQL"),
    MY_SQL(0, "MySQL", "Mysql"),
    ORACLE(0, "Oracle", "Oracle"),
    POSTGRE_SQL(0, "PostgreSQL", "PostgreSQL");

    public static final int HSQL_VALUE = 0;
    public static final int MY_SQL_VALUE = 0;
    public static final int ORACLE_VALUE = 0;
    public static final int POSTGRE_SQL_VALUE = 0;
    private static final DatabaseProvider[] VALUES_ARRAY;
    public static final List<DatabaseProvider> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static DatabaseProvider get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DatabaseProvider result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DatabaseProvider getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DatabaseProvider result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DatabaseProvider get(int value) {
        switch (value) {
            case 0: {
                return HSQL;
            }
        }
        return null;
    }

    private DatabaseProvider(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new DatabaseProvider[]{HSQL, MY_SQL, ORACLE, POSTGRE_SQL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

