/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineOutput.java 7786 2011-03-03 10:51:54Z durieuxp $
 * --------------------------------------------------------------------------
 */

 package org.ow2.jasmine.monitoring.mbeancmd.api;

/**
 * Used to define OUTPUT arguments for a JASMINe probes.
 * @author danesa
 */
public class JasmineOutput {
    /**
     * Output name (output identifier).
     */
    private String name = null;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * Indicates whether some other object is "equal to" this one.
     * @param obj The other object to compare
     * @return true if both objects are the same.
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (! (obj instanceof JasmineOutput)) {
            return false;
        }
        JasmineOutput other = (JasmineOutput) obj;
        return other.getName().equals(name);
    }

    /**
     * Returns a hash code value for the object.
     * @return hashcode value
     */
    public int hashCode() {
        return name == null ? 0 : name.length();
    }

    /**
     * @return string representation of the object.
     */
    public String toString() {
        return name;
    }
}

