/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineTarget.java 8028 2011-04-15 15:26:21Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.mbeancmd.api;


/**
 * Provides a JASMINe target definition elements:
 * its name and url for the jmx connection.
 * @author danesa
 */
public class JasmineTarget {

    /**
     * Target name.
     */
    private String name = null;

    /**
     * Contains the target's URL.
     */
    private String jmxUrl = null;

    /**
     * User name to use when connecting to JMX.
     */
    private String user = null;

    /**
     * Password to use when connecting to JMX.
     */
    private String password = null;

    /**
     * Protocol provider list to use when connecting to JMX.
     */
    private String protocolProviders = null;

    /**
     *  State Management.
     *  This information should be set only on the server side.
     */
    private int state = TARGET_UNKNOWN;

    public static final int TARGET_UNKNOWN = 0;
    public static final int TARGET_RUNNING = 1;
    public static final int TARGET_FAILED = 2;

    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }

    public String getJmxUrl() {
        return jmxUrl;
    }
    public void setJmxUrl(String jmxUrl) {
        this.jmxUrl = jmxUrl;
    }

    public String getUser() {
        return user;
    }
    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return password;
    }
    public void setPassword(String password) {
        this.password = password;
    }

    public String getProtocolProviders() {
        return protocolProviders;
    }
    public void setProtocolProviders(String protocolProviders) {
        this.protocolProviders = protocolProviders;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    /**
     * Indicates whether some other object is "equal to" this one.
     * @param obj The other object to compare
     * @return true if both objects are the same.
     */
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (! (obj instanceof JasmineTarget)) {
            return false;
        }
        JasmineTarget other = (JasmineTarget) obj;
        return other.getName().equals(name) && other.getJmxUrl().equals(jmxUrl);
    }

    /**
     * Returns a hash code value for the object.
     * @return hashcode value
     */
    public int hashCode() {
        return name == null ? 0 : name.length();
    }

    /**
     * @return string representation of the object.
     */
    public String toString() {
        return name + ":" + jmxUrl;
    }
}
