/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.context;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.JmxAp;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JmxContext
implements Serializable {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = -9159123017384356614L;
    protected String name = null;
    protected String server = null;
    protected String domain;
    protected String jmxUrl = null;
    protected JmxAp jmxap = null;
    protected Set<ObjectName> onames = null;
    private boolean started = false;
    private boolean interrupted = false;
    private long interruptionTime;
    private static final long MINUTE = 60000L;
    private static final long LOG_PERIOD = 600000L;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    public void setJmxUrl(String jmxUrl) {
        this.jmxUrl = jmxUrl;
    }

    public JmxAp getJmxap() {
        return this.jmxap;
    }

    public void setJmxap(JmxAp jmxap) {
        this.jmxap = jmxap;
    }

    public Set<ObjectName> getOnames() {
        return this.onames;
    }

    public void setOnames(Set<ObjectName> onames) {
        this.onames = onames;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.jmxap.getMBeanServerConnection();
    }

    public void updateOnames(String onPattern) throws Exception {
        Set<ObjectName> onSet = this.getObjectNames(onPattern);
        this.setOnames(onSet);
    }

    public void updateOnames(ObjectName onPattern) throws Exception {
        Set<ObjectName> onSet = this.getObjectNames(onPattern);
        this.setOnames(onSet);
    }

    public Set<ObjectName> getObjectNames(String onPattern) throws Exception {
        MBeanServerConnection cnx = this.getMBeanServerConnection();
        Set<ObjectName> onSet = null;
        if (onPattern != null) {
            ObjectName on = null;
            try {
                on = ObjectName.getInstance(onPattern);
            }
            catch (MalformedObjectNameException me) {
                this.logger.error("MBean discovery: failed probe on target {0} because of erroneous ObjectName: {1}, caught exception with message: {2}", this.getName(), onPattern, me.getMessage());
                throw me;
            }
            onSet = this.getObjectNames(on);
        }
        return onSet;
    }

    public Set<ObjectName> getObjectNames(ObjectName onPattern) throws Exception {
        MBeanServerConnection cnx = this.getMBeanServerConnection();
        Set onSet = null;
        if (onPattern != null) {
            try {
                onSet = cnx.queryNames(onPattern, null);
                if (!this.isStarted()) {
                    this.logger.info("MBean discovery succesful. Got probes for target {0}", this.getName());
                } else {
                    this.logger.debug("MBean discovery succesful. Got probes for target {0}", this.getName());
                }
                if (this.interrupted && this.isStarted()) {
                    this.interrupted = false;
                    this.logger.info("MBean discovery succesful. Got probes for target {0}", this.getName());
                }
            }
            catch (IOException e) {
                if (!this.interrupted) {
                    this.resetInterruptionTime();
                    this.interrupted = true;
                    this.logger.error("MBean discovery: failed probe on target {0}, caught exception with message: {1}", this.getName(), e.getMessage());
                } else {
                    boolean deltaElapsed = this.isDeltaTimeElapsed();
                    if (deltaElapsed) {
                        this.logger.error("MBean discovery: failed probe on target {0}, caught exception with message: {1}", this.getName(), e.getMessage());
                        this.resetInterruptionTime();
                    }
                }
                throw e;
            }
        }
        return onSet;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    private void resetInterruptionTime() {
        this.interruptionTime = System.currentTimeMillis();
    }

    private boolean isDeltaTimeElapsed() {
        long deltaTime = System.currentTimeMillis() - this.interruptionTime;
        return deltaTime > 600000L;
    }
}

