/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.JCACFData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.XSampleData;

public class JCACFSampler
extends Sampler {
    private static final String[] attIds = new String[]{"currentOpened", "currentBusy", "maxSize", "currentInTx", "busyMin", "busyMax", "openedCount", "connectionFailures", "connectionLeaks", "currentWaiters", "waitersHighRecent", "waitersHigh", "waiterCount", "waitingHigh", "waitingHighRecent", "waitingTime", "servedOpen", "rejectedOpen", "rejectedFull", "rejectedTimeout", "rejectedOther"};

    public JCACFSampler(SamplerContext context) {
        super(context);
    }

    public String getDefaultOnPattern() {
        return "*:j2eeType=JCAConnectionFactory,*";
    }

    protected SampleData newSampleData() {
        return new XSampleData();
    }

    protected SampleData poll(SampleData data) {
        this.pollJCACFs((XSampleData)data);
        data.setValid(true);
        return data;
    }

    private void pollJCACFs(XSampleData data) {
        ObjectName[] oNames = this.context.getOnames().toArray(new ObjectName[this.context.getOnames().size()]);
        for (int i = 0; i < oNames.length; ++i) {
            JCACFData cfdata = new JCACFData();
            cfdata.setObjectName(oNames[i]);
            cfdata.setSampleTime(System.currentTimeMillis());
            this.pollJCACF(oNames[i], cfdata);
            if (!cfdata.isValid()) continue;
            data.put(oNames[i], cfdata);
        }
    }

    private void pollJCACF(ObjectName on, JCACFData data) {
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        try {
            cnx = this.getMBeanServerConnection();
            al = cnx.getAttributes(on, attIds);
            this.releaseMbeanServerConnection();
            cnx = null;
            for (Attribute att : al) {
                data.setAttribute(att);
            }
            data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
            data.setCmdId(this.getCmdId());
            data.setValid(true);
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace(System.err);
        }
        catch (ReflectionException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }
}

