/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Outer
implements Runnable {
    private boolean goOn = true;
    private PipedInputStream source = null;
    private LineNumberReader rsource = null;
    private PipedOutputStream sink = null;
    private PrintWriter wsink = null;
    private PrintWriter target = null;
    private boolean isFormat = false;
    private String[] heading = null;
    private String[] columns = null;
    private int[] colIndexes = null;
    private boolean isFilter = false;
    private String regexp = null;
    private static final String COLSEP = ";";
    private static String separator = ";";
    private boolean isTimeFilter = false;
    private String timeField = "time";
    private SimpleDateFormat timeFormat = null;
    private int timeIx = -1;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private long fromTime = 0L;
    private long toTime = 0L;
    private String id = "";
    private boolean isTargetSystemOut = false;
    private Log logger = LogFactory.getLog(Outer.class);

    public Outer(PipedOutputStream src, PrintStream target) throws IOException {
        this.source = new PipedInputStream(src);
        this.rsource = new LineNumberReader(new InputStreamReader(this.source));
        this.target = target != null ? new PrintWriter(target, true) : null;
        this.setSink(null);
    }

    public Outer(PipedOutputStream src) throws IOException {
        this.source = new PipedInputStream(src);
        this.rsource = new LineNumberReader(new InputStreamReader(this.source));
        this.target = new PrintWriter(System.out);
        this.isTargetSystemOut = true;
    }

    public Outer(PipedOutputStream src, File file) throws IOException {
        this.source = new PipedInputStream(src);
        this.rsource = new LineNumberReader(new InputStreamReader(this.source));
        if (file.isDirectory()) {
            throw new IOException("File " + file.getPath() + " is a directory");
        }
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        this.target = new PrintWriter((Writer)new FileWriter(file), true);
        this.setSink(null);
    }

    public void setSink(PipedOutputStream sink) {
        if (sink == null) {
            this.setSink(new PipedOutputStream());
        } else {
            if (this.wsink != null) {
                try {
                    this.wsink.close();
                    this.sink.close();
                }
                catch (Exception e) {
                    this.logger.warn("Error while closing sink : {0}", e);
                }
            }
            this.sink = sink;
            this.wsink = new PrintWriter((Writer)new OutputStreamWriter(sink), true);
        }
    }

    public PipedOutputStream getSink() {
        return this.sink;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static void main(String[] args) throws IOException {
        PipedOutputStream src = new PipedOutputStream();
        PrintWriter wsrc = new PrintWriter(src);
        Outer outer = new Outer(src, System.out);
        Outer.setSeparator("\t");
        String[] format = new String[]{"time", "a", "c", "f", "name"};
        outer.setFormatter(format);
        outer.setRegexp(".*:*type=bbb,.*");
        Outer outer2 = new Outer(outer.getSink(), new File("toto.log"));
        outer2.setRegexp(".*aaa.*name=n0.$");
        new Thread(outer2).start();
        new Thread(outer).start();
        String[] names = new String[]{"org.ow2.jasmine.monitoring.mbeancmd:type=aaa,name=n00", "org.ow2.jasmine.monitoring.mbeancmd:type=bbb,name=n01", "org.ow2.jasmine.monitoring.mbeancmd:type=aaa,name=n02", "org.ow2.jasmine.monitoring.mbeancmd:type=aaa,name=n03", "org.ow2.jasmine.monitoring.mbeancmd:type=bbb,name=n04", "org.ow2.jasmine.monitoring.mbeancmd:type=bbb,name=n05", "org.ow2.jasmine.monitoring.mbeancmd:type=aaa,name=n06", "org.ow2.jasmine.monitoring.mbeancmd:type=aaa,name=n07", "org.ow2.jasmine.monitoring.mbeancmd:type=aaa,name=n08", "org.ow2.jasmine.monitoring.mbeancmd:type=bbb,name=n09", "org.ow2.jasmine.monitoring.mbeancmd:type=bbb,name=n10"};
        wsrc.println("time\ta\tb\tc\td\te\tf\tname");
        for (int i = 1; i <= 10; ++i) {
            wsrc.println("" + i + "\t" + (100 + i) + "\t" + (200 + i) + "\t" + (300 + i) + "\t" + (400 + i) + "\t" + (500 + i) + "\t" + (600 + i) + "\t" + names[i - 1]);
            wsrc.flush();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        src.close();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("org.ow2.jasmine.monitoring.mbeancmd.Outer.main has completed.");
    }

    public void run() {
        long count = 0L;
        while (this.goOn) {
            try {
                String ln = this.rsource.readLine();
                if (ln == null) {
                    this.goOn = false;
                    continue;
                }
                ++count;
                if (this.heading == null) {
                    this.setHeading(ln);
                }
                if (this.target != null && this.matches(ln) && this.timeMatches(ln)) {
                    if (this.isFormat) {
                        String[] s = ln.split(separator);
                        for (int i = 0; i < this.colIndexes.length; ++i) {
                            this.target.print(s[this.colIndexes[i]]);
                            if (i == this.colIndexes.length - 1) continue;
                            this.target.print(separator);
                        }
                        this.target.println();
                        this.target.flush();
                    } else {
                        this.target.println(ln);
                        this.target.flush();
                    }
                }
                if (this.wsink == null) continue;
                this.wsink.println(ln);
            }
            catch (IOException e) {
                this.goOn = false;
            }
        }
        if (this.target != null) {
            this.target.flush();
            if (!this.isTargetSystemOut) {
                this.target.close();
            }
        }
        if (this.wsink != null) {
            try {
                this.wsink.flush();
                this.wsink.close();
                this.sink.close();
            }
            catch (Exception e) {
                this.logger.error("Error closing outputs : {0}", e.getMessage(), e);
            }
        }
    }

    public void stop() {
        this.goOn = false;
    }

    private void setHeading(String h) {
        this.isFormat = false;
        this.heading = h == null ? null : h.split(separator);
        if (this.columns != null && this.heading != null) {
            this.isFormat = this.buildIndex();
        }
        if (this.isTimeFilter && this.heading != null) {
            int i = 0;
            for (i = 0; i < this.heading.length; ++i) {
                if (!this.timeField.equals(this.heading[i])) continue;
                this.timeIx = i;
                break;
            }
            if (i == this.heading.length) {
                this.resetTimeFilter();
            }
        }
    }

    public void setFormatter(String[] columns) {
        this.isFormat = false;
        this.columns = columns != null ? (String[])columns.clone() : null;
        if (columns != null && this.heading != null) {
            this.isFormat = this.buildIndex();
        }
    }

    public void setRegexp(String exp) {
        this.isFilter = exp != null;
        this.regexp = exp;
    }

    public void setTimeFilter(String field, String fieldFormat, String from, String to) {
        try {
            this.timeField = field;
            this.timeFormat = fieldFormat == null ? null : new SimpleDateFormat(fieldFormat);
            this.fromTime = this.simpleDateFormat.parse(from).getTime();
            this.toTime = this.simpleDateFormat.parse(to).getTime();
            this.isTimeFilter = true;
        }
        catch (ParseException e) {
            this.resetTimeFilter();
            this.logger.error("Parse error when setting a time filter : {0}", e.getMessage(), e);
        }
    }

    public void resetTimeFilter() {
        this.isTimeFilter = false;
        this.timeField = "time";
        this.timeFormat = null;
        this.fromTime = 0L;
        this.toTime = 0L;
        this.timeIx = -1;
    }

    public static String getSeparator() {
        return separator;
    }

    public static void setSeparator(String s) {
        separator = s;
    }

    private boolean matches(String ln) {
        if (!this.isFilter) {
            return true;
        }
        if (this.rsource.getLineNumber() == 1) {
            return true;
        }
        if (this.heading == null) {
            return true;
        }
        return ln.matches(this.regexp);
    }

    private boolean timeMatches(String ln) {
        if (!this.isTimeFilter) {
            return true;
        }
        if (this.rsource.getLineNumber() == 1) {
            return true;
        }
        if (this.heading == null) {
            return true;
        }
        boolean ret = false;
        String[] s = ln.split(separator);
        try {
            long time = this.getTime(s[this.timeIx]);
            if (this.fromTime <= time && time < this.toTime) {
                ret = true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace(System.err);
            this.logger.error("Error trying to match a time filter : {0}", e.getMessage(), e);
        }
        catch (ParseException e) {
            e.printStackTrace(System.err);
            this.logger.error("Error trying to match a time filter : {0}", e.getMessage(), e);
        }
        return ret;
    }

    private long getTime(String t) throws ParseException {
        if (this.timeFormat == null) {
            return Long.parseLong(t);
        }
        return this.timeFormat.parse(t).getTime();
    }

    private boolean buildIndex() {
        boolean format = false;
        LinkedList<String> names = new LinkedList<String>();
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        for (int i = 0; i < this.columns.length; ++i) {
            boolean colFound = false;
            for (int j = 0; j < this.heading.length; ++j) {
                if (!this.heading[j].equals(this.columns[i])) continue;
                names.add(this.heading[j]);
                indexes.add(new Integer(j));
                colFound = true;
                break;
            }
            if (colFound) continue;
            throw new ArrayIndexOutOfBoundsException("Column " + this.columns[i] + " not found in data header.");
        }
        if (names.size() > 0) {
            String[] cols = new String[names.size()];
            this.colIndexes = new int[indexes.size()];
            for (int i = 0; i < this.colIndexes.length; ++i) {
                cols[i] = (String)names.get(i);
                this.colIndexes[i] = (Integer)indexes.get(i);
            }
            this.columns = cols;
            format = true;
        } else {
            this.columns = null;
            this.colIndexes = null;
        }
        return format;
    }
}

