/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.audit;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.audit.InvalidMetricRadical;
import org.ow2.jasmine.monitoring.mbeancmd.audit.util.MetricMath;

public class Metric {
    private long timestamp = 0L;
    private String source = null;
    private ObjectName name = null;
    private AttributeList attributes = null;
    private String radical = null;

    public Metric(Long t, String source, ObjectName name, AttributeList attl) {
        this.timestamp = t;
        this.source = source;
        this.name = name;
        this.attributes = attl;
        this.radical = source + "@" + (name == null ? "null" : name.toString());
    }

    public Attribute getAttribute(String name) {
        Attribute attRet = null;
        for (Attribute att : this.attributes) {
            if (!att.getName().equals(name)) continue;
            attRet = att;
            break;
        }
        return attRet;
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public ObjectName getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getRadical() {
        return this.radical;
    }

    public static Metric delta(Metric current, Metric baseline, String attr) {
        Attribute batt;
        Metric ret = null;
        Attribute catt = current == null ? null : current.getAttribute(attr);
        Attribute attribute = batt = baseline == null ? null : baseline.getAttribute(attr);
        if (catt == null || !MetricMath.isNum(catt.getValue())) {
            return null;
        }
        double c = MetricMath.toDouble(catt);
        double b = MetricMath.toDouble(batt);
        AttributeList l = new AttributeList();
        l.add(new Attribute(attr, c - b));
        ret = new Metric(current.getTimestamp(), current.getSource(), current.getName(), l);
        return ret;
    }

    public static Metric newInstance(String radical) throws InvalidMetricRadical {
        String[] s = radical.split("@");
        if (s.length != 2) {
            throw new InvalidMetricRadical(radical);
        }
        ObjectName on = null;
        try {
            on = ObjectName.getInstance(s[1]);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return new Metric(System.currentTimeMillis(), s[0], on, new AttributeList());
    }
}

