/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.message;

import java.util.Date;
import java.util.Iterator;
import org.mule.impl.RequestContext;
import org.mule.impl.message.BaseMessage;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;

public class ExceptionMessage
extends BaseMessage {
    private static final long serialVersionUID = -538516243574950621L;
    private Throwable exception;
    private String componentName;
    private UMOEndpointURI endpointUri;
    private Date timeStamp;

    public ExceptionMessage(Object message, Throwable exception, String componentName, UMOEndpointURI endpointUri) {
        super(message);
        this.exception = exception;
        this.timeStamp = new Date();
        this.componentName = componentName;
        this.endpointUri = endpointUri;
        UMOEventContext ctx = RequestContext.getEventContext();
        if (ctx != null) {
            UMOMessage msg = ctx.getMessage();
            Iterator iterator = msg.getPropertyNames().iterator();
            while (iterator.hasNext()) {
                String propertyKey = (String)iterator.next();
                this.setProperty(propertyKey, msg.getProperty(propertyKey));
            }
        }
    }

    public String getComponentName() {
        return this.componentName;
    }

    public UMOEndpointURI getEndpoint() {
        return this.endpointUri;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "ExceptionMessage{message=" + this.message + ", context=" + this.context + "exception=" + this.exception + ", componentName='" + this.componentName + "'" + ", endpointUri=" + this.endpointUri + ", timeStamp=" + this.timeStamp + "}";
    }
}

